/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.flink.runtime.state.gemini.engine.memstore;

import org.apache.flink.runtime.state.gemini.engine.GRegion;
import org.apache.flink.runtime.state.gemini.engine.page.PageStore;
import org.apache.flink.runtime.state.gemini.engine.page.bmap.GComparator;

import org.apache.flink.shaded.netty4.io.netty.util.concurrent.EventExecutor;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;
import java.util.TreeMap;

/**
 * writeBuffer.
 */
public class WriteBufferKSortedMapHashImpl<K, MK, MV> extends AbstractWriteBufferKMapHashImpl<K, MK, MV> {
	private static final Logger LOG = LoggerFactory.getLogger(WriteBufferKSortedMapHashImpl.class);
	private final GComparator<MK> gComparator;

	public WriteBufferKSortedMapHashImpl(
		GRegion gRegion, EventExecutor eventExecutor, PageStore pageStore, GComparator<MK> gComparator) {
		super(gRegion, eventExecutor, pageStore);
		this.gComparator = gComparator;
		initActive();
	}

	@Override
	protected void initActive() {
		this.active = new SegmentKMapImpl<>(segmentID++, gRegionContext, this.gComparator);
	}

	@Override
	Segment addFlushingSegment() {
		Segment result = active;
		snapshotQueue.add(active);
		gRegionContext.getWriteBufferStats().addFlushingSegmentCount(1);
		active = new SegmentKMapImpl<>(segmentID++, gRegionContext, this.gComparator);
		return result;
	}

	@Override
	public Map<MK, GSValue<MV>> createPOJOMap() {
		return new TreeMap<>(gComparator.getJDKCompactor());
	}

	//TODO NOTE: WriteBuffer support InternalSortedMap is useless, because there are map entry which is deleted.
	//We should get the totalMap.
//	@Override
//	public GSValueMapEntry<MK, MV> firstEntry(K key) {
//		//Delete mk
//		GSValueMap<MK, MV> gsValueMap = get(key);
//		return null;
//	}
//
//	@Override
//	public GSValueMapEntry<MK, MV> lastEntry(K key) {
//		return null;
//	}
//
//	@Override
//	public GSValueMap<MK, MV> head(K key, MK endMapKey) {
//		return null;
//	}
//
//	@Override
//	public GSValueMap<MK, MV> tail(K key, MK startMapKey) {
//		return null;
//	}
//
//	@Override
//	public GSValueMap<MK, MV> subMap(K key, MK startMapKey, MK endMapKey) {
//		return null;
//	}
}
