/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.flink.runtime.state.gemini.engine.memstore;

import org.apache.flink.runtime.state.gemini.engine.metrics.MetricsRegisterAble;
import org.apache.flink.runtime.state.gemini.engine.snapshot.SnapshotOperation;

/**
 * WriteBufferManager. Single instance per DB.
 */
public interface WriteBufferManager extends MetricsRegisterAble {
	/**
	 * trigger all of WriteBuffer.
	 */
	void doSnapshot(SnapshotOperation snapshotOperation);

	void increaseWriteBufferFlushBlock();

	void addTotalRecordCount(int totalRecordCount);

	long getTotalRecordCount();

	void addTotalFlushingRecordCount(int totalRecordCount);

	void addTotalFlushingSegmentCount(int flushingSegmentCount);

	long getTotalMemSize();

	/**
	 * check if this writeBuffer can be choose to flush, such as size ranking.
	 * if bestChoice is not this writeBuffer, return false, otherwise return true.
	 */
	boolean isBestChoiceWriteBufferFlushing(WriteBuffer writeBuffer);

	/**
	 * Check if the specified write buffer can be flushed according to the total flushing
	 * segments. Return false if there is too much flushing segments, otherwise return true.
	 */
	boolean canFlushWriteBuffer(WriteBuffer writeBuffer);

	void addTableNum(String tableName);
}
