/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.flink.runtime.state.gemini.engine.metrics;

import org.apache.flink.metrics.MetricGroup;

/**
 * Page Cache stats, including data cache hit rate, flush or fetch throughput, occupation etc.
 * // TODO add some metrics
 */
public class CacheMetrics extends MetricsBase {
	public static final String TOTAL_PAGE_USED_MEMORY = "totalPageUsedMemory";
	public static final String TOTAL_LOGIC_PAGE_SIZE = "totalLogicPageSize";
	public static final String TOTAL_INDEX_CAPACITY = "totalIndexCapacity";
	public static final String TOTAL_LOGIC_PAGE_COUNT = "totalLogicPageCount";
	public static final String AVERAGE_PAGE_CHAIN_LEN = "averagePageChainLen";
	public static final String AVERAGE_PAGE_SIZE = "averagePageSize";
	public static final String AVERAGE_MINOR_COMPACTION_PAGE_NUM = "averageMinorCompactionPageNum";
	public static final String AVERAGE_MAJOR_COMPACTION_PAGE_NUM = "averageMajorCompactionPageNum";
	public static final String TOTAL_WR_BUFFER_HIT_COUNT = "totalWriteBufferHitCount";
	public static final String TOTAL_WR_BUFFER_MISS_COUNT = "totalWriteBufferMissCount";
	public static final String TOTAL_PAGE_CACHE_HIT_COUNT = "totalPageCacheHitCount";
	public static final String TOTAL_PAGE_CACHE_LRU_HIT_COUNT = "totalPageCacheLRUHitCount";
	public static final String TOTAL_PAGE_CACHE_MISS_COUNT = "totalPageCacheMissCount";
	public static final String TOTAL_PAGE_EVICT_SIZE = "totalPageCacheEvictSize";
	public static final String TOTAL_RUNNING_MARJOR_COMPACTION = "totalRunningMajorCompaction";
	public static final String TOTAL_RUNNING_MINOR_COMPACTION = "totalRunningMinorCompaction";
	public static final String TOTAL_MEM_HIGH_MARK = "totalMemHighMark";
	public static final String TOTAL_MEM_MIDDLE_MARK = "totalMemMiddleMark";
	public static final String TOTAL_MEM_LOW_MARK = "totalMemLowMark";
	public static final String TOTAL_EVICT_BLOCK_COUNT = "totalEvictBlockCount";

	public CacheMetrics(MetricGroup metricGroup, int sampleCountInterval) {
		this(metricGroup, sampleCountInterval, DEFAULT_HISTOGRAM_WINDOW_SIZE);
	}

	public CacheMetrics(MetricGroup metricGroup, int sampleCountInterval, int histogramWindowSize) {
		super(metricGroup, sampleCountInterval, histogramWindowSize);
	}
}
