/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.flink.runtime.state.gemini.engine.metrics;

import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.state.gemini.engine.ExceptionStat;

/**
 * All metrics about Exceptions.
 */
public class ExceptionMetrics extends MetricsBase {
	public static final String FILE_SHIFT_TOTAL_COUNT = "totalFileShiftCount";
	public static final String FILEWRITER_SHIFT_TOTAL_COUNT = "totalFileWriterShiftCount";

	private boolean hasRegistered;

	public ExceptionMetrics(MetricGroup metricGroup, int sampleCountInterval) {
		this(metricGroup, sampleCountInterval, DEFAULT_HISTOGRAM_WINDOW_SIZE);
	}

	public ExceptionMetrics(MetricGroup metricGroup, int sampleCountInterval, int histogramWindowSize) {
		super(metricGroup, sampleCountInterval, histogramWindowSize);
	}

	public void register(ExceptionStat exceptionStat) {
		synchronized (this) {
			if (hasRegistered) {
				return;
			}
			hasRegistered = true;
		}

		getGaugeMetric(FILE_SHIFT_TOTAL_COUNT, () -> exceptionStat.addTotalWriterException(0));
		getGaugeMetric(FILEWRITER_SHIFT_TOTAL_COUNT, () -> exceptionStat.addTotalFileWriterShift(0));
	}
}

