/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.flink.runtime.state.gemini.engine.metrics;

import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.state.gemini.engine.fs.FileCleanerStat;

/**
 * File cleaner metrics.
 */
public class FileCleanerMetrics extends MetricsBase {

	private static final String RECEIVED_FILES = "received_files";

	private static final String DELETED_FILES = "deleted_files";

	private static final String FAILED_DELETE_FILES = "failed_delete_files";

	private boolean hasRegistered;

	public FileCleanerMetrics(MetricGroup metricGroup, int sampleCountInterval) {
		this(metricGroup, sampleCountInterval, DEFAULT_HISTOGRAM_WINDOW_SIZE);
	}

	public FileCleanerMetrics(MetricGroup metricGroup, int sampleCountInterval, int histogramWindowSize) {
		super(metricGroup, sampleCountInterval, histogramWindowSize);
		this.hasRegistered = false;
	}

	public void register(FileCleanerStat fileCleanerStat) {
		synchronized (this) {
			if (hasRegistered) {
				return;
			}
			hasRegistered = true;
		}

		getGaugeMetric(RECEIVED_FILES, () -> fileCleanerStat.addTotalReceivedFile(0));
		getGaugeMetric(DELETED_FILES, () -> fileCleanerStat.addTotalDeletedFile(0));
		getGaugeMetric(FAILED_DELETE_FILES, () -> fileCleanerStat.addTotalFailedDeletedFiles(0));
	}
}
