/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.flink.runtime.state.gemini.engine.metrics;

import org.apache.flink.metrics.Histogram;
import org.apache.flink.metrics.MetricGroup;

/**
 * GeminiMetrics.
 * TODO call the metrics in the state
 */
public class GeminiMetrics extends MetricsBase {

	private static final String METRIC_GEMINI_GET = "get";
	private static final String METRIC_GEMINI_PUT = "put";
	private static final String METRIC_GEMINI_DELETE = "delete";
	private static final String METRIC_GEMINI_SNAPSHOT_SYNC_PHASE = "sync_snapshot";
	private static final String METRIC_GEMINI_SNAPSHOT_ASYNC_PHASE = "async_snapshot";

	public GeminiMetrics(MetricGroup metricGroup, int sampleCountInterval) {
		this(metricGroup, sampleCountInterval, DEFAULT_HISTOGRAM_WINDOW_SIZE);
	}

	public GeminiMetrics(MetricGroup metricGroup, int sampleCountInterval, int histogramWindowSize) {
		super(metricGroup, sampleCountInterval, histogramWindowSize);
	}

	public Histogram getGetHistogram() {
		return getHistogramMetric(METRIC_GEMINI_GET);
	}

	public Histogram getPutHistogram() {
		return getHistogramMetric(METRIC_GEMINI_PUT);
	}

	public Histogram getDeleteHistogram() {
		return getHistogramMetric(METRIC_GEMINI_DELETE);
	}

	public void reportSnapshotSyncPhase(long latency) {
		getGaugeMetric(METRIC_GEMINI_SNAPSHOT_SYNC_PHASE).updateValue(latency);
	}

	public void reportSnapshotAsyncPhase(long latency) {
		getGaugeMetric(METRIC_GEMINI_SNAPSHOT_ASYNC_PHASE).updateValue(latency);
	}
}
