/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.flink.runtime.state.gemini.engine.page;

import org.apache.flink.api.common.typeutils.CompatibilityResult;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConfigSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.state.gemini.engine.exceptions.GeminiRuntimeException;
import org.apache.flink.runtime.state.gemini.engine.rm.Allocator;
import org.apache.flink.runtime.state.gemini.engine.rm.UnpoolAllocatorImpl;

import java.io.IOException;

/**
 * AbstractGValueTypeSerializer for Gemini's Map/List value.
 */
public abstract class AbstractGValueTypeSerializer<G> extends TypeSerializer<G> {

	protected final Allocator allocator = new UnpoolAllocatorImpl();

	@Override
	public boolean isImmutableType() {
		return false;
	}

	@Override
	public TypeSerializer<G> duplicate() {
		throw new GeminiRuntimeException("GMapValueTypeSerialiZer not support yet.");
	}

	@Override
	public G createInstance() {
		throw new GeminiRuntimeException("GMapValueTypeSerialiZer not support yet.");
	}

	@Override
	public G copy(G from) {
		throw new GeminiRuntimeException("GMapValueTypeSerialiZer not support yet.");
	}

	@Override
	public G copy(G from, G reuse) {
		throw new GeminiRuntimeException("GMapValueTypeSerialiZer not support yet.");
	}

	@Override
	public int getLength() {
		throw new GeminiRuntimeException("GMapValueTypeSerialiZer not support yet.");
	}

	@Override
	public G deserialize(G reuse, DataInputView source) throws IOException {
		throw new GeminiRuntimeException("GMapValueTypeSerialiZer not support yet.");
	}

	@Override
	public void copy(DataInputView source, DataOutputView target) throws IOException {
		throw new GeminiRuntimeException("GMapValueTypeSerialiZer not support yet.");
	}

	@Override
	public boolean equals(Object obj) {
		throw new GeminiRuntimeException("GMapValueTypeSerialiZer not support yet.");
	}

	@Override
	public boolean canEqual(Object obj) {
		return false;
	}

	@Override
	public int hashCode() {
		throw new GeminiRuntimeException("GMapValueTypeSerialiZer not support yet.");
	}

	@Override
	public TypeSerializerConfigSnapshot snapshotConfiguration() {
		throw new GeminiRuntimeException("GMapValueTypeSerialiZer not support yet.");
	}

	@Override
	public CompatibilityResult<G> ensureCompatibility(TypeSerializerConfigSnapshot configSnapshot) {
		throw new GeminiRuntimeException("GMapValueTypeSerialiZer not support yet.");
	}
}
