/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.flink.runtime.state.gemini.engine.page;

import org.apache.flink.runtime.state.gemini.engine.exceptions.GeminiRuntimeException;

/**
 * GValueType. only 4 bit.
 */
public enum GValueType {
	Delete((byte) 1),
	PutValue((byte) 2),
	PutMap((byte) 3),
	PutList((byte) 4),
	AddMap((byte) 8),
	AddList((byte) 9);

	private final byte code;

	GValueType(final byte c) {
		this.code = c;
	}

	public byte getCode() {
		return this.code;
	}

	public static GValueType valueOf(byte gvalueType) {
		switch (gvalueType) {
			case 1:
				return Delete;
			case 2:
				return PutValue;
			case 3:
				return PutMap;
			case 4:
				return PutList;
			case 8:
				return AddMap;
			case 9:
				return AddList;
			default:
				throw new GeminiRuntimeException("Error GValueType:" + gvalueType);
		}
	}
}
