/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.flink.runtime.state.gemini.engine.page;

import org.apache.flink.runtime.state.gemini.engine.snapshot.RegionSnapshot;
import org.apache.flink.runtime.state.gemini.engine.snapshot.SnapshotMetaFile;

import javax.annotation.Nullable;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

/**
 * LogicPage.
 */
public interface LogicChainedPage {

	boolean setPageStatus(PageStatus expectedStatus, PageStatus targetStatus);

	void addPageSize(int pageSize);

	int getPageSize();

	PageStatus getPageStatus();

	/**
	 * getPageAddress.
	 *
	 * @param chainIndex from 0;
	 * @return pageAddress.
	 */
	PageAddress getPageAddress(int chainIndex);

	/**
	 * create page or add delta page, will increase page chain.
	 *
	 * @return logic page chain index.
	 */
	PageAddress createPage(long initRequestCount, DataPage dataPage);

	/**
	 * insert a existed page.
	 *
	 * @param pageAddress existed page.
	 * @return logic page chain index.
	 */
	int insertPage(PageAddress pageAddress);

	/**
	 * @return logic page current chain index. from 0. -1 means no page.
	 */
	int getCurrentPageChainIndex();

	int getPageChainCapacity();

	LogicChainedPage deepCopy(Map<PageAddress, DataPage> allAddReferenceDataPage);

	Iterator<PageAddress> pageIterator();

	/**
	 * Return a map mapping file id to a tuple which contains the total references to the file,
	 * and total data size in this file.
	 */
	void snapshot(@Nullable RegionSnapshot localRegionSnapshot, RegionSnapshot dfsRegionSnapshot) throws IOException;

	void restore(SnapshotMetaFile.Reader reader, PageStoreStats pageStoreStats) throws IOException;
}
