/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.flink.runtime.state.gemini.engine.page;

import org.apache.flink.runtime.state.gemini.engine.snapshot.RegionSnapshot;

import javax.annotation.Nullable;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

/**
 * PageIndex.
 * logic page id:  4bytes: 6bits+26bits. and 26bits is offset of array of LogicChainedPage[].
 */
public interface PageIndex<K> {
	PageIndexContext getPageIndexContext(K key, boolean createIfMiss);

	void expand();

	void shrink();

	/**
	 * should flush all page related to checkPointID to fs.
	 * Return the map mapping file id to a tuple which contains the total references to the file,
	 * and total data size in this file.
	 */
	void snapshot(@Nullable RegionSnapshot localRegionSnapshot, RegionSnapshot dfsRegionSnapshot) throws IOException;

	boolean updateLogicPageStatus(
		int pageID, PageStatus expectedStatus, PageStatus targetStatus);

	PageIndex<K> deepCopy(Map<PageAddress, DataPage> allAddReferenceDataPage);

	/**
	 * remove logicPage.
	 *
	 * @param baseLogicPageID base logicPageID without chain len.
	 */
	void removeLogicPage(int baseLogicPageID);

	LogicChainedPage getLogicPage(int baseLogicPageID);

	void updateLogicPage(int baseLogicPageID, LogicChainedPage destLogicPage);

	LogicChainedPage newLogicChainedPage();

	Iterator<PageAddress> pageIterator();

	int getIndexCapacity();

	LogicChainedPage[] getPageIndex();
}
