/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.flink.runtime.state.gemini.engine.page;

import org.apache.flink.runtime.state.gemini.engine.exceptions.GeminiRuntimeException;

/**
 * PageStatus. only 1 bit. should be less than 127.
 */
public enum PageStatus {
	Init((byte) 1),
	Normal((byte) 2),
	Flushing((byte) 3),
	Flushed((byte) 4),
	Fetching((byte) 5),
	Fetched((byte) 6),
	Compacting((byte) 7);

	private final byte code;

	PageStatus(final byte c) {
		this.code = c;
	}

	public byte getCode() {
		return this.code;
	}

	public static PageStatus valueOf(byte status) {
		switch (status) {
			case 1:
				return Init;
			case 2:
				return Normal;
			case 3:
				return Flushing;
			case 4:
				return Flushed;
			case 5:
				return Fetching;
			case 6:
				return Fetched;
			case 7:
				return Compacting;
			default:
				throw new GeminiRuntimeException("Error PageStatus:" + status);
		}
	}

	public boolean canCompaction() {
		return this != Compacting;
	}

	public boolean canFlush() {
		return  this != Flushing || this != Compacting;
	}
}
