/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.flink.runtime.state.gemini.engine.page.bmap;

import org.apache.flink.runtime.state.gemini.engine.page.GValueType;
import org.apache.flink.runtime.state.gemini.engine.utils.SeqIDUtils;

import java.nio.ByteBuffer;

/**
 * BinaryValue for BinaryHashMap.
 */
public final class BinaryValue {
	public static final BinaryValue DELETED_BINARY_VALUE = new BinaryValue(null, GValueType.Delete, SeqIDUtils.INVALID_SEQID, -1, -1);
	private final GValueType gValueType;
	private final int valueOffset;
	private final int valueLen;
	// BinaryValue is internal data structure, so no need GByteBuffer to release reference count.
	private final ByteBuffer bb;
	private final long seqID;

	public BinaryValue(ByteBuffer data, GValueType gValueType, long seqID, int valueOffset, int valueLen) {
		this.bb = data;
		this.gValueType = gValueType;
		this.seqID = seqID;
		this.valueOffset = valueOffset;
		this.valueLen = valueLen;
	}

	public GValueType getgValueType() {
		return gValueType;
	}

	public int getValueOffset() {
		return valueOffset;
	}

	public int getValueLen() {
		return valueLen;
	}

	public ByteBuffer getBb() {
		return bb;
	}

	public long getSeqID() {
		return seqID;
	}
}
