/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.flink.runtime.state.gemini.engine.page.bmap;

import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.gemini.engine.exceptions.GeminiRuntimeException;

import java.util.Collection;
import java.util.Map;
import java.util.Set;

/**
 * GAbstractHashMap. If we want to support interface of Map.
 */
public abstract class GAbstractHashMap<K> implements Map<K, BinaryValue> {

	@Override
	public boolean containsValue(Object value) {
		throw new GeminiRuntimeException("GBinaryHashMap not support yet.");
	}

	@Override
	public BinaryValue put(K key, BinaryValue value) {
		throw new GeminiRuntimeException("GBinaryHashMap immutable.");
	}

	@Override
	public BinaryValue remove(Object key) {
		throw new GeminiRuntimeException("GBinaryHashMap immutable.");
	}

	@Override
	public void putAll(Map<? extends K, ? extends BinaryValue> m) {
		throw new GeminiRuntimeException("GBinaryHashMap immutable.");
	}

	@Override
	public void clear() {
		throw new GeminiRuntimeException("GBinaryHashMap immutable.");
	}

	@Override
	public Set<K> keySet() {
		throw new GeminiRuntimeException("GBinaryHashMap not support yet.");
	}

	@Override
	public Collection<BinaryValue> values() {
		throw new GeminiRuntimeException("GBinaryHashMap not support yet.");
	}

	@Override
	public Set<Entry<K, BinaryValue>> entrySet() {
		throw new GeminiRuntimeException("GBinaryHashMap not support yet.");
	}

	public abstract long getCompactionCount();

	public abstract int keyCount();

	public abstract int bytesSize();

	public abstract int indexCount();

	public abstract int getHashCode(int indexLen, int keyCursor);

	public abstract Map<BinaryKey, BinaryValue> getBinaryMap();

	public abstract TypeSerializer<K> getKeyTypeSerializer();
}
