/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.flink.runtime.state.gemini.engine.page.bmap;

import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.gemini.engine.exceptions.GeminiRuntimeException;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;

/**
 * GAbstractSortedMap. If we want to support interface of Map.
 */
public abstract class GAbstractSortedMap<MK> implements SortedMap<MK, BinaryValue> {

	public abstract long getCompactionCount();

	public abstract int keyCount();

	public abstract int bytesSize();

	public abstract SortedMap<BinaryKey, BinaryValue> getSortedBinaryMap();

	public abstract Map<BinaryKey, BinaryValue> getBinaryMap();

	public abstract TypeSerializer<MK> getKeyTypeSerializer();

	@Override
	public boolean containsValue(Object value) {
		throw new GeminiRuntimeException("GBinarySortedMap immutable.");
	}

	@Override
	public BinaryValue put(MK key, BinaryValue value) {
		throw new GeminiRuntimeException("GBinarySortedMap immutable.");
	}

	@Override
	public BinaryValue remove(Object key) {
		throw new GeminiRuntimeException("GBinarySortedMap immutable.");
	}

	@Override
	public void putAll(Map<? extends MK, ? extends BinaryValue> m) {
		throw new GeminiRuntimeException("GBinarySortedMap immutable.");
	}

	@Override
	public void clear() {
		throw new GeminiRuntimeException("GBinarySortedMap immutable.");
	}

	@Override
	public Set<MK> keySet() {
		throw new GeminiRuntimeException("GBinarySortedMap not support yet.");
	}

	@Override
	public Collection<BinaryValue> values() {
		throw new GeminiRuntimeException("GBinarySortedMap not support yet.");
	}

	@Override
	public Set<Entry<MK, BinaryValue>> entrySet() {
		throw new GeminiRuntimeException("GBinarySortedMap not support yet.");
	}
}
