/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.flink.runtime.state.gemini.engine.page.compress;

/**
 * GCompressAlgorithm.
 */
public enum GCompressAlgorithm {
	None((byte) 1){
		@Override
		public CompressorCodec getCompressorCodec() {
			return null;
		}
	},
	Lz4((byte) 2){
		private ThreadLocal<CompressorCodec> compressorCodecThreadLocal = ThreadLocal.withInitial(() -> new LZ4CompressorCodec());
		@Override
		public CompressorCodec getCompressorCodec() {
			return compressorCodecThreadLocal.get();
		}
	},
	Snappy((byte) 3){
		private ThreadLocal<CompressorCodec> compressorCodecThreadLocal = ThreadLocal.withInitial(() -> new SnappyCompressorCodec());
		@Override
		public CompressorCodec getCompressorCodec() {
			return compressorCodecThreadLocal.get();
		}
	};

	private final byte code;

	GCompressAlgorithm(final byte c) {
		this.code = c;
	}

	public byte getCode() {
		return this.code;
	}

	public static GCompressAlgorithm valueOf(byte gvalueType) {
		switch (gvalueType) {
			case 1:
				return None;
			case 2:
				return Lz4;
			case 3:
				return Snappy;
			default:
				return None;
		}
	}

	public abstract CompressorCodec getCompressorCodec();
}
