/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.flink.runtime.state.gemini.engine.rm;

import org.apache.flink.runtime.state.gemini.engine.exceptions.GeminiRuntimeException;

/**
 * ReferenceCount.
 */
public interface ReferenceCount {

	/**
	 * ReleaseType. @see #DiscardOrEvictPageReleaseManager.
	 */
	enum ReleaseType {
		//Normal means this reference is hold by a local variant. release this reference when this local variant finish it's process.
		Normal,
		Discard,
		Evict
	}

	/**
	 * add referencecount().
	 */
	void contain();

	/**
	 * decrease referenceCount.
	 */
	void release(ReleaseType releaseType) throws GeminiRuntimeException;

	/**
	 * get referenceCount.
	 */
	int getCnt();

	/**
	 * if set seqID, then should wait this seq done.
	 */
	void setSeqID(long seqID);

	/**
	 * get seqID need to wait when need recalim.
	 *
	 * @return
	 */
	long getSeqID();

}
