/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.flink.runtime.state.gemini.engine.rm;

import org.apache.flink.runtime.state.gemini.engine.exceptions.GeminiException;

import org.apache.flink.shaded.guava18.com.google.common.base.MoreObjects;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;

/**
 * UnpoolAllocatorImpl.
 */
public class UnpoolAllocatorImpl implements Allocator {

	private final AtomicLong currentSize = new AtomicLong(0);

	@Override
	public GByteBuffer allocate(int len) throws GeminiException {
		currentSize.addAndGet(len);
		return new GUnPooledByteBuffer(ByteBuffer.allocate(len), len, this);
	}

	@Override
	public void close() {
		//do nothing
	}

	@Override
	public void release(ReferenceCount.ReleaseType releaseType, GByteBuffer gByteBuffer) {

	}

	@Override
	public void statSize(int len) {
		currentSize.addAndGet(-len);
	}

	@Override
	public String toString() {
		return MoreObjects.toStringHelper(this).
			add("currentSize", currentSize).toString();
		//current netty don't have metrics. new version will have. add("metric", pooledByteBufAllocator.)
	}
}

