/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.flink.runtime.state.gemini.engine.snapshot;

import org.apache.flink.runtime.state.SnapshotDirectory;
import org.apache.flink.util.Preconditions;

import javax.annotation.Nullable;

/**
 * This class contains the combined results from the snapshot of a DB.
 */
public class DBSnapshotResult {

	/**
	 * Directory where data is stored for DFS snapshot.
	 */
	private final SnapshotDirectory dfsSnapshotDirectory;

	/**
	 * Meta for DFS snapshot result.
	 */
	private final DBSnapshotMeta dfsSnapshotMeta;

	/**
	 * Directory where data is stored for local snapshot.
	 */
	@Nullable
	private final SnapshotDirectory localSnapshotDirectory;

	/**
	 * Meta for local snapshot result.
	 */
	@Nullable
	private final DBSnapshotMeta localSnapshotMeta;

	public DBSnapshotResult(
		SnapshotDirectory dfsSnapshotDirectory,
		DBSnapshotMeta dfsSnapshotMeta) {
		this(null, null, dfsSnapshotDirectory, dfsSnapshotMeta);
	}

	public DBSnapshotResult(
		SnapshotDirectory localSnapshotDirectory,
		DBSnapshotMeta localSnapshotMeta,
		SnapshotDirectory dfsSnapshotDirectory,
		DBSnapshotMeta dfsSnapshotMeta) {
		this.localSnapshotDirectory = localSnapshotDirectory;
		this.localSnapshotMeta = localSnapshotMeta;
		this.dfsSnapshotDirectory = Preconditions.checkNotNull(dfsSnapshotDirectory);
		this.dfsSnapshotMeta = Preconditions.checkNotNull(dfsSnapshotMeta);
	}

	public SnapshotDirectory getDfsSnapshotDirectory() {
		return dfsSnapshotDirectory;
	}

	@Nullable
	public SnapshotDirectory getLocalSnapshotDirectory() {
		return localSnapshotDirectory;
	}

	public DBSnapshotMeta getDfsSnapshotMeta() {
		return dfsSnapshotMeta;
	}

	@Nullable
	public DBSnapshotMeta getLocalSnapshotMeta() {
		return localSnapshotMeta;
	}
}
