/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.flink.runtime.state.gemini.keyed;

import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.gemini.engine.hashtable.AbstractGTableKeyedMapImpl;
import org.apache.flink.runtime.state.keyed.KeyedMapState;
import org.apache.flink.runtime.state.keyed.KeyedMapStateDescriptor;
import org.apache.flink.runtime.state.keyed.KeyedStateDescriptor;

import java.util.HashMap;
import java.util.Map;

import static org.apache.flink.util.Preconditions.checkNotNull;

/**
 * GeminiKeyedMapStateImpl.
 * @param <K>
 * @param <MK>
 * @param <MV>
 */
public class GeminiKeyedMapStateImpl<K, MK, MV>
	extends AbstractGeminiKeyedMapStateImpl<K, MK, MV, Map<MK, MV>>
	implements KeyedMapState<K, MK, MV> {
	private KeyedMapStateDescriptor<K, MK, MV> descriptor;

	public GeminiKeyedMapStateImpl(
		KeyedMapStateDescriptor<K, MK, MV> descriptor,
		AbstractGTableKeyedMapImpl<K, MK, MV> table) {
		super(table);
		this.descriptor = checkNotNull(descriptor);
	}

	@Override
	Map<MK, MV> createMap() {
		return new HashMap<>();
	}

	@Override
	public KeyedStateDescriptor getDescriptor() {
		return descriptor;
	}

	@Override
	public byte[] getSerializedValue(byte[] serializedKeyAndNamespace, TypeSerializer<K> safeKeySerializer, TypeSerializer<Map<MK, MV>> safeValueSerializer) throws Exception {
		return new byte[0];
	}
}

