/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.flink.runtime.state.gemini.subkeyed;

import org.apache.flink.runtime.state.StateStorage;
import org.apache.flink.runtime.state.gemini.engine.hashtable.GTableSubKeyedMapImpl;
import org.apache.flink.runtime.state.subkeyed.SubKeyedMapState;
import org.apache.flink.runtime.state.subkeyed.SubKeyedMapStateDescriptor;

import java.util.HashMap;
import java.util.Map;

/**
 * An implementation of {@link SubKeyedMapState} backed by a state storage.
 *
 * @param <K> Type of the keys in the state.
 * @param <N> Type of the namespaces in the state.
 * @param <MK> Type of the map keys in the state.
 * @param <MV> Type of the map values in the state.
 */
public final class GeminiSubKeyedMapStateImpl<K, N, MK, MV>
	extends AbstractGeminiSubKeyedMapStateImpl<K, N, MK, MV, Map<MK, MV>>
	implements SubKeyedMapState<K, N, MK, MV> {

	private final SubKeyedMapStateDescriptor<K, N, MK, MV> descriptor;

	public GeminiSubKeyedMapStateImpl(
		SubKeyedMapStateDescriptor descriptor,
		GTableSubKeyedMapImpl table) {
		super(table);
		this.descriptor = descriptor;
	}

	@Override
	public StateStorage<K, Map<MK, MV>> getStateStorage() {
		return null;
	}

	@Override
	public SubKeyedMapStateDescriptor getDescriptor() {
		return descriptor;
	}

	@Override
	Map<MK, MV> createMap() {
		return new HashMap<>();
	}
}
