/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.flink.runtime.taskexecutor;

import org.apache.flink.annotation.VisibleForTesting;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

import static org.apache.flink.util.Preconditions.checkNotNull;

/**
 *
 */
public class ResultPartitionReport implements Serializable, Iterable<ResultPartitionStatus> {

	private final Collection<ResultPartitionStatus> resultPartitionStatus;

	@VisibleForTesting
	public ResultPartitionReport() {
		this(Collections.emptyList());
	}

	@VisibleForTesting
	public ResultPartitionReport(ResultPartitionStatus resultPartitionStatus) {
		this(Collections.singletonList(resultPartitionStatus));
	}

	public ResultPartitionReport(Collection<ResultPartitionStatus> resultPartitionStatus) {
		this.resultPartitionStatus = checkNotNull(resultPartitionStatus);
	}

	@Override
	public Iterator<ResultPartitionStatus> iterator() {
		return resultPartitionStatus.iterator();
	}
}
