/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.flink.runtime.taskexecutor;

import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;

import java.io.Serializable;
import java.util.Objects;

import static org.apache.flink.util.Preconditions.checkNotNull;

/**
 * This describes the status of the result partitions.
 */
public class ResultPartitionStatus implements Serializable {

	private static final long serialVersionUID = 2283091321692010110L;

	/** The job id */
	private final JobID jobId;

	private final ResultPartitionID partitionId;

	public ResultPartitionStatus(JobID jobId, ResultPartitionID partitionId) {
		this.jobId = checkNotNull(jobId);
		this.partitionId = checkNotNull(partitionId);
	}

	public JobID getJobId() {
		return jobId;
	}

	public ResultPartitionID getPartitionId() {
		return partitionId;
	}

	@Override
	public boolean equals(Object o) {
		if (this == o) {
			return true;
		}

		if (o == null || getClass() != o.getClass()) {
			return false;
		}

		ResultPartitionStatus that = (ResultPartitionStatus) o;
		return Objects.equals(jobId, that.jobId) &&
			Objects.equals(partitionId, that.partitionId);
	}

	@Override
	public int hashCode() {
		return Objects.hash(jobId, partitionId);
	}

	@Override
	public String toString() {
		return "ResultPartitionStatus{" +
			"jobId=" + jobId +
			", partitionId=" + partitionId +
			'}';
	}
}
