/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.BlobServerOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.blob.BlobInputStream;
import org.apache.flink.runtime.blob.BlobKey;
import org.apache.flink.runtime.blob.BlobOutputStream;
import org.apache.flink.runtime.blob.BlobUtils;
import org.apache.flink.runtime.blob.PermanentBlobKey;
import org.apache.flink.runtime.blob.TransientBlobKey;
import org.apache.flink.runtime.net.SSLUtils;
import org.apache.flink.util.IOUtils;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BlobClient
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(BlobClient.class);
    private Socket socket;

    public BlobClient(InetSocketAddress serverAddress, Configuration clientConfig) throws IOException {
        try {
            SSLContext clientSSLContext = null;
            if (clientConfig != null && clientConfig.getBoolean(BlobServerOptions.SSL_ENABLED)) {
                clientSSLContext = SSLUtils.createSSLClientContext(clientConfig);
            }
            if (clientSSLContext != null) {
                LOG.info("Using ssl connection to the blob server");
                SSLSocket sslSocket = (SSLSocket)clientSSLContext.getSocketFactory().createSocket();
                if (!serverAddress.getAddress().isLoopbackAddress()) {
                    SSLParameters newSSLParameters = sslSocket.getSSLParameters();
                    SSLUtils.setSSLVerifyHostname(clientConfig, newSSLParameters);
                    sslSocket.setSSLParameters(newSSLParameters);
                }
                this.socket = sslSocket;
            } else {
                this.socket = new Socket();
            }
            this.socket.connect(serverAddress, clientConfig.getInteger(BlobServerOptions.CONNECT_TIMEOUT));
            this.socket.setSoTimeout(clientConfig.getInteger(BlobServerOptions.SO_TIMEOUT));
        }
        catch (Exception e) {
            BlobUtils.closeSilently(this.socket, LOG);
            throw new IOException("Could not connect to BlobServer at address " + serverAddress, e);
        }
    }

    /*
     * Exception decompiling
     */
    static void downloadFromBlobServer(@Nullable JobID jobId, BlobKey blobKey, File localJarFile, InetSocketAddress serverAddress, Configuration blobClientConfig, int numFetchRetries) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void close() throws IOException {
        this.socket.close();
    }

    public boolean isClosed() {
        return this.socket.isClosed();
    }

    InputStream getInternal(@Nullable JobID jobId, BlobKey blobKey) throws IOException {
        if (this.socket.isClosed()) {
            throw new IllegalStateException("BLOB Client is not connected. Client has been shut down or encountered an error before.");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("GET BLOB {}/{} from {}.", new Object[]{jobId, blobKey, this.socket.getLocalSocketAddress()});
        }
        try {
            OutputStream os = this.socket.getOutputStream();
            InputStream is = this.socket.getInputStream();
            BlobClient.sendGetHeader(os, jobId, blobKey);
            BlobClient.receiveAndCheckGetResponse(is);
            return new BlobInputStream(is, blobKey, os);
        }
        catch (Throwable t) {
            BlobUtils.closeSilently(this.socket, LOG);
            throw new IOException("GET operation failed: " + t.getMessage(), t);
        }
    }

    private static void sendGetHeader(OutputStream outputStream, @Nullable JobID jobId, BlobKey blobKey) throws IOException {
        Preconditions.checkNotNull((Object)blobKey);
        Preconditions.checkArgument((jobId != null || blobKey instanceof TransientBlobKey ? 1 : 0) != 0, (Object)"permanent BLOBs must be job-related");
        outputStream.write(1);
        if (jobId == null) {
            outputStream.write(0);
        } else {
            outputStream.write(2);
            outputStream.write(jobId.getBytes());
        }
        blobKey.writeToOutputStream(outputStream);
    }

    private static void receiveAndCheckGetResponse(InputStream is) throws IOException {
        int response = is.read();
        if (response < 0) {
            throw new EOFException("Premature end of response");
        }
        if (response == 1) {
            Throwable cause = BlobUtils.readExceptionFromStream(is);
            throw new IOException("Server side error: " + cause.getMessage(), cause);
        }
        if (response != 0) {
            throw new IOException("Unrecognized response");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    BlobKey putBuffer(@Nullable JobID jobId, byte[] value, int offset, int len, BlobKey.BlobType blobType) throws IOException {
        if (this.socket.isClosed()) {
            throw new IllegalStateException("BLOB Client is not connected. Client has been shut down or encountered an error before.");
        }
        Preconditions.checkNotNull((Object)value);
        if (LOG.isDebugEnabled()) {
            LOG.debug("PUT BLOB buffer (" + len + " bytes) to " + this.socket.getLocalSocketAddress() + ".");
        }
        try (BlobOutputStream os = new BlobOutputStream(jobId, blobType, this.socket);){
            os.write(value, offset, len);
            BlobKey blobKey = os.finish();
            return blobKey;
        }
        catch (Throwable t) {
            BlobUtils.closeSilently(this.socket, LOG);
            throw new IOException("PUT operation failed: " + t.getMessage(), t);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    BlobKey putInputStream(@Nullable JobID jobId, InputStream inputStream, BlobKey.BlobType blobType) throws IOException {
        if (this.socket.isClosed()) {
            throw new IllegalStateException("BLOB Client is not connected. Client has been shut down or encountered an error before.");
        }
        Preconditions.checkNotNull((Object)inputStream);
        if (LOG.isDebugEnabled()) {
            LOG.debug("PUT BLOB stream to {}.", (Object)this.socket.getLocalSocketAddress());
        }
        try (BlobOutputStream os = new BlobOutputStream(jobId, blobType, this.socket);){
            IOUtils.copyBytes((InputStream)inputStream, (OutputStream)os, (int)65536, (boolean)false);
            BlobKey blobKey = os.finish();
            return blobKey;
        }
        catch (Throwable t) {
            BlobUtils.closeSilently(this.socket, LOG);
            throw new IOException("PUT operation failed: " + t.getMessage(), t);
        }
    }

    public static List<PermanentBlobKey> uploadFiles(InetSocketAddress serverAddress, Configuration clientConfig, JobID jobId, List<Path> files) throws IOException {
        Preconditions.checkNotNull((Object)jobId);
        if (files.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<PermanentBlobKey> blobKeys = new ArrayList<PermanentBlobKey>();
        try (BlobClient blobClient = new BlobClient(serverAddress, clientConfig);){
            for (Path file : files) {
                PermanentBlobKey key = blobClient.uploadFile(jobId, file);
                blobKeys.add(key);
            }
        }
        return blobKeys;
    }

    public PermanentBlobKey uploadFile(JobID jobId, Path file) throws IOException {
        FileSystem fs = file.getFileSystem();
        try (FSDataInputStream is = fs.open(file);){
            PermanentBlobKey permanentBlobKey = (PermanentBlobKey)this.putInputStream(jobId, (InputStream)is, BlobKey.BlobType.PERMANENT_BLOB);
            return permanentBlobKey;
        }
    }
}

