/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.BlobServerOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.blob.AbstractBlobCache;
import org.apache.flink.runtime.blob.BlobKey;
import org.apache.flink.runtime.blob.BlobUtils;
import org.apache.flink.runtime.blob.BlobView;
import org.apache.flink.runtime.blob.PermanentBlobKey;
import org.apache.flink.runtime.blob.PermanentBlobService;
import org.apache.flink.util.FileUtils;
import org.apache.flink.util.Preconditions;
import org.slf4j.LoggerFactory;

public class PermanentBlobCache
extends AbstractBlobCache
implements PermanentBlobService {
    private final Map<JobID, RefCount> jobRefCounters = new HashMap<JobID, RefCount>();
    private final long cleanupInterval;
    private final Timer cleanupTimer = new Timer(true);

    public PermanentBlobCache(Configuration blobClientConfig, BlobView blobView, @Nullable InetSocketAddress serverAddress) throws IOException {
        super(blobClientConfig, blobView, LoggerFactory.getLogger(PermanentBlobCache.class), serverAddress);
        this.cleanupInterval = blobClientConfig.getLong(BlobServerOptions.CLEANUP_INTERVAL) * 1000L;
        this.cleanupTimer.schedule((TimerTask)new PermanentBlobCleanupTask(), this.cleanupInterval, this.cleanupInterval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerJob(JobID jobId) {
        Preconditions.checkNotNull((Object)jobId);
        Map<JobID, RefCount> map = this.jobRefCounters;
        synchronized (map) {
            RefCount ref = this.jobRefCounters.get(jobId);
            if (ref == null) {
                ref = new RefCount();
                this.jobRefCounters.put(jobId, ref);
            } else {
                ref.keepUntil = -1L;
            }
            ++ref.references;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseJob(JobID jobId) {
        Preconditions.checkNotNull((Object)jobId);
        Map<JobID, RefCount> map = this.jobRefCounters;
        synchronized (map) {
            RefCount ref = this.jobRefCounters.get(jobId);
            if (ref == null || ref.references == 0) {
                this.log.warn("improper use of releaseJob() without a matching number of registerJob() calls for jobId " + jobId);
                return;
            }
            --ref.references;
            if (ref.references == 0) {
                ref.keepUntil = System.currentTimeMillis() + this.cleanupInterval;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfReferenceHolders(JobID jobId) {
        Preconditions.checkNotNull((Object)jobId);
        Map<JobID, RefCount> map = this.jobRefCounters;
        synchronized (map) {
            RefCount ref = this.jobRefCounters.get(jobId);
            if (ref == null) {
                return 0;
            }
            return ref.references;
        }
    }

    public int getNumberOfCachedJobs() {
        return this.jobRefCounters.size();
    }

    @Override
    public File getFile(JobID jobId, PermanentBlobKey key) throws IOException {
        Preconditions.checkNotNull((Object)jobId);
        return this.getFileInternal(jobId, key);
    }

    @VisibleForTesting
    public File getStorageLocation(JobID jobId, BlobKey key) throws IOException {
        Preconditions.checkNotNull((Object)jobId);
        return BlobUtils.getStorageLocation(this.storageDir, jobId, key);
    }

    @VisibleForTesting
    Map<JobID, RefCount> getJobRefCounters() {
        return this.jobRefCounters;
    }

    @Override
    protected void cancelCleanupTask() {
        this.cleanupTimer.cancel();
    }

    class PermanentBlobCleanupTask
    extends TimerTask {
        PermanentBlobCleanupTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Map map = PermanentBlobCache.this.jobRefCounters;
            synchronized (map) {
                Iterator entryIter = PermanentBlobCache.this.jobRefCounters.entrySet().iterator();
                long currentTimeMillis = System.currentTimeMillis();
                while (entryIter.hasNext()) {
                    Map.Entry entry = entryIter.next();
                    RefCount ref = (RefCount)entry.getValue();
                    if (ref.references > 0 || ref.keepUntil <= 0L || currentTimeMillis < ref.keepUntil) continue;
                    JobID jobId = (JobID)entry.getKey();
                    File localFile = new File(BlobUtils.getStorageLocationPath(PermanentBlobCache.this.storageDir.getAbsolutePath(), jobId));
                    PermanentBlobCache.this.readWriteLock.writeLock().lock();
                    boolean success = false;
                    try {
                        FileUtils.deleteDirectory((File)localFile);
                        success = true;
                    }
                    catch (Throwable t) {
                        PermanentBlobCache.this.log.warn("Failed to locally delete job directory " + localFile.getAbsolutePath(), t);
                    }
                    finally {
                        PermanentBlobCache.this.readWriteLock.writeLock().unlock();
                    }
                    if (!success) continue;
                    entryIter.remove();
                }
            }
        }
    }

    @VisibleForTesting
    static class RefCount {
        public int references = 0;
        public long keepUntil = -1L;

        RefCount() {
        }
    }
}

