/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.runtime.checkpoint.CompletedCheckpoint;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStore;
import org.apache.flink.runtime.jobgraph.JobStatus;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandaloneCompletedCheckpointStore
implements CompletedCheckpointStore {
    private static final Logger LOG = LoggerFactory.getLogger(StandaloneCompletedCheckpointStore.class);
    private final int maxNumberOfCheckpointsToRetain;
    private final ArrayDeque<CompletedCheckpoint> checkpoints;

    public StandaloneCompletedCheckpointStore(int maxNumberOfCheckpointsToRetain) {
        Preconditions.checkArgument((maxNumberOfCheckpointsToRetain >= 1 ? 1 : 0) != 0, (Object)"Must retain at least one checkpoint.");
        this.maxNumberOfCheckpointsToRetain = maxNumberOfCheckpointsToRetain;
        this.checkpoints = new ArrayDeque(maxNumberOfCheckpointsToRetain + 1);
    }

    @Override
    public void recover() throws Exception {
    }

    @Override
    public CompletedCheckpoint addCheckpoint(CompletedCheckpoint checkpoint) throws Exception {
        CompletedCheckpoint checkpointToSubsume = null;
        this.checkpoints.addLast(checkpoint);
        if (this.checkpoints.size() > this.maxNumberOfCheckpointsToRetain) {
            try {
                checkpointToSubsume = this.checkpoints.removeFirst();
                checkpointToSubsume.discardOnSubsume();
            }
            catch (Exception e) {
                LOG.warn("Fail to subsume the old checkpoint.", (Throwable)e);
            }
        }
        return checkpointToSubsume;
    }

    @Override
    public CompletedCheckpoint getLatestCheckpoint() {
        return this.checkpoints.isEmpty() ? null : this.checkpoints.getLast();
    }

    @Override
    public List<CompletedCheckpoint> getAllCheckpoints() {
        return new ArrayList<CompletedCheckpoint>(this.checkpoints);
    }

    @Override
    public int getNumberOfRetainedCheckpoints() {
        return this.checkpoints.size();
    }

    @Override
    public int getMaxNumberOfRetainedCheckpoints() {
        return this.maxNumberOfCheckpointsToRetain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown(JobStatus jobStatus) throws Exception {
        try {
            LOG.info("Shutting down");
            for (CompletedCheckpoint checkpoint : this.checkpoints) {
                checkpoint.discardOnShutdown(jobStatus);
            }
        }
        finally {
            this.checkpoints.clear();
        }
    }

    @Override
    public boolean requiresExternalizedCheckpoints() {
        return false;
    }
}

