/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.savepoint;

import java.util.Collection;
import org.apache.flink.runtime.checkpoint.MasterState;
import org.apache.flink.runtime.checkpoint.OperatorState;
import org.apache.flink.runtime.checkpoint.TaskState;
import org.apache.flink.runtime.checkpoint.savepoint.Savepoint;
import org.apache.flink.util.Preconditions;

public class SavepointV3
implements Savepoint {
    public static final int VERSION = 3;
    private final long checkpointId;
    private final Collection<OperatorState> operatorStates;
    private final Collection<MasterState> masterStates;

    public SavepointV3(long checkpointId, Collection<OperatorState> operatorStates, Collection<MasterState> masterStates) {
        this.checkpointId = checkpointId;
        this.operatorStates = operatorStates;
        this.masterStates = (Collection)Preconditions.checkNotNull(masterStates, (String)"masterStates");
    }

    @Override
    public long getCheckpointId() {
        return this.checkpointId;
    }

    @Override
    public Collection<TaskState> getTaskStates() {
        throw new UnsupportedOperationException("TaskStates is no longer supported.");
    }

    @Override
    public Collection<MasterState> getMasterStates() {
        return this.masterStates;
    }

    @Override
    public Collection<OperatorState> getOperatorStates() {
        return this.operatorStates;
    }

    public int getVersion() {
        return 3;
    }

    public void dispose() throws Exception {
        for (OperatorState operatorState : this.operatorStates) {
            operatorState.discardState();
        }
        this.operatorStates.clear();
        this.masterStates.clear();
    }

    public String toString() {
        return "Checkpoint Metadata (version=3)";
    }
}

