/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.clusterframework.overlays;

import java.io.File;
import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.SecurityOptions;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.clusterframework.ContainerSpecification;
import org.apache.flink.runtime.clusterframework.overlays.AbstractContainerOverlay;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeytabOverlay
extends AbstractContainerOverlay {
    private static final Logger LOG = LoggerFactory.getLogger(KeytabOverlay.class);
    static final Path TARGET_PATH = new Path("krb5.keytab");
    final Path keytab;

    public KeytabOverlay(@Nullable File keytab) {
        this.keytab = keytab != null ? new Path(keytab.toURI()) : null;
    }

    public KeytabOverlay(@Nullable Path keytab) {
        this.keytab = keytab;
    }

    @Override
    public void configure(ContainerSpecification container) throws IOException {
        if (this.keytab != null) {
            container.getArtifacts().add(ContainerSpecification.Artifact.newBuilder().setSource(this.keytab).setDest(TARGET_PATH).setCachable(false).build());
            container.getDynamicConfiguration().setString(SecurityOptions.KERBEROS_LOGIN_KEYTAB, TARGET_PATH.getPath());
        }
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        File keytabPath;

        public Builder fromEnvironment(Configuration globalConfiguration) {
            String keytab = globalConfiguration.getString(SecurityOptions.KERBEROS_LOGIN_KEYTAB);
            if (keytab != null) {
                this.keytabPath = new File(keytab);
                if (!this.keytabPath.exists()) {
                    throw new IllegalStateException("Invalid configuration for " + SecurityOptions.KERBEROS_LOGIN_KEYTAB + "; '" + keytab + "' not found.");
                }
            }
            return this;
        }

        public KeytabOverlay build() {
            return new KeytabOverlay(this.keytabPath);
        }
    }
}

