/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.deployment;

import java.net.InetSocketAddress;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.deployment.ResultPartitionLocation;
import org.apache.flink.runtime.deployment.ResultPartitionLocationTracker;
import org.apache.flink.runtime.executiongraph.IntermediateResult;
import org.apache.flink.runtime.io.network.ConnectionID;
import org.apache.flink.runtime.io.network.partition.external.ExternalBlockShuffleServiceOptions;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;

public class ExternalResultPartitionLocationTracker
implements ResultPartitionLocationTracker {
    private final Configuration configuration;

    public ExternalResultPartitionLocationTracker(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public ResultPartitionLocation getResultPartitionLocation(TaskManagerLocation producerLocation, TaskManagerLocation consumerLocation, IntermediateResult intermediateResult) {
        Integer dataPort = this.configuration.getInteger(ExternalBlockShuffleServiceOptions.FLINK_SHUFFLE_SERVICE_PORT_KEY);
        InetSocketAddress address = new InetSocketAddress(producerLocation.address(), (int)dataPort);
        ConnectionID connectionId = new ConnectionID(address, intermediateResult.getConnectionIndex());
        return ResultPartitionLocation.createRemote(connectionId);
    }
}

