/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.deployment;

import java.io.Serializable;
import org.apache.flink.runtime.deployment.ResultPartitionLocation;
import org.apache.flink.runtime.deployment.ResultPartitionLocationTrackerProxy;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.Execution;
import org.apache.flink.runtime.executiongraph.ExecutionEdge;
import org.apache.flink.runtime.executiongraph.ExecutionGraphException;
import org.apache.flink.runtime.executiongraph.IntermediateResultPartition;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.jobmaster.LogicalSlot;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.util.Preconditions;

public class InputChannelDeploymentDescriptor
implements Serializable {
    private static final long serialVersionUID = 373711381640454080L;
    private final ResultPartitionID consumedPartitionId;
    private final ResultPartitionLocation consumedPartitionLocation;

    public InputChannelDeploymentDescriptor(ResultPartitionID consumedPartitionId, ResultPartitionLocation consumedPartitionLocation) {
        this.consumedPartitionId = (ResultPartitionID)Preconditions.checkNotNull((Object)consumedPartitionId);
        this.consumedPartitionLocation = (ResultPartitionLocation)Preconditions.checkNotNull((Object)consumedPartitionLocation);
    }

    public ResultPartitionID getConsumedPartitionId() {
        return this.consumedPartitionId;
    }

    public ResultPartitionLocation getConsumedPartitionLocation() {
        return this.consumedPartitionLocation;
    }

    public String toString() {
        return String.format("InputChannelDeploymentDescriptor [consumed partition id: %s, consumed partition location: %s]", this.consumedPartitionId, this.consumedPartitionLocation);
    }

    public static InputChannelDeploymentDescriptor[] fromEdges(ResultPartitionLocationTrackerProxy resultPartitionLocationTrackerProxy, ExecutionEdge[] edges, TaskManagerLocation consumerLocation, boolean allowLazyDeployment) throws ExecutionGraphException {
        InputChannelDeploymentDescriptor[] icdd = new InputChannelDeploymentDescriptor[edges.length];
        for (int i = 0; i < edges.length; ++i) {
            ResultPartitionLocation partitionLocation;
            IntermediateResultPartition consumedPartition = edges[i].getSource();
            Execution producer = consumedPartition.getProducer().getCurrentExecutionAttempt();
            ExecutionState producerState = producer.getState();
            LogicalSlot producerSlot = producer.getAssignedResource();
            if ((consumedPartition.getResultType().isPipelined() || consumedPartition.isConsumable()) && producerSlot != null && (producerState == ExecutionState.RUNNING || producerState == ExecutionState.FINISHED || producerState == ExecutionState.SCHEDULED || producerState == ExecutionState.DEPLOYING)) {
                TaskManagerLocation partitionTaskManagerLocation = producerSlot.getTaskManagerLocation();
                partitionLocation = resultPartitionLocationTrackerProxy.getResultPartitionLocation(partitionTaskManagerLocation, consumerLocation, consumedPartition.getIntermediateResult());
            } else if (allowLazyDeployment) {
                partitionLocation = ResultPartitionLocation.createUnknown();
            } else {
                String msg;
                if (producerState == ExecutionState.CANCELING || producerState == ExecutionState.CANCELED || producerState == ExecutionState.FAILED) {
                    msg = "Trying to schedule a task whose inputs were canceled or failed. The producer is in state " + (Object)((Object)producerState) + ".";
                    throw new ExecutionGraphException(msg);
                }
                msg = String.format("Trying to eagerly schedule a task whose inputs are not ready (result type: %s, partition consumable: %s, producer state: %s, producer slot: %s).", new Object[]{consumedPartition.getResultType(), consumedPartition.isConsumable(), producerState, producerSlot});
                throw new ExecutionGraphException(msg);
            }
            ResultPartitionID consumedPartitionId = new ResultPartitionID(consumedPartition.getPartitionId(), producer.getAttemptId());
            icdd[i] = new InputChannelDeploymentDescriptor(consumedPartitionId, partitionLocation);
        }
        return icdd;
    }
}

