/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.dispatcher;

import java.util.Collection;
import java.util.Collections;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobmanager.SubmittedJobGraph;
import org.apache.flink.runtime.jobmanager.SubmittedJobGraphStore;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.Preconditions;

public class SingleJobSubmittedJobGraphStore
implements SubmittedJobGraphStore {
    private final JobGraph jobGraph;

    public SingleJobSubmittedJobGraphStore(JobGraph jobGraph) {
        this.jobGraph = (JobGraph)Preconditions.checkNotNull((Object)jobGraph);
    }

    @Override
    public void start(SubmittedJobGraphStore.SubmittedJobGraphListener jobGraphListener) throws Exception {
    }

    @Override
    public void stop() throws Exception {
    }

    @Override
    public SubmittedJobGraph recoverJobGraph(JobID jobId) throws Exception {
        if (this.jobGraph.getJobID().equals((Object)jobId)) {
            return new SubmittedJobGraph(this.jobGraph, null);
        }
        throw new FlinkException("Could not recover job graph " + jobId + '.');
    }

    @Override
    public void putJobGraph(SubmittedJobGraph jobGraph) throws Exception {
        if (!jobGraph.getJobId().equals((Object)jobGraph.getJobId())) {
            throw new FlinkException("Cannot put additional jobs into this submitted job graph store.");
        }
    }

    @Override
    public void removeJobGraph(JobID jobId) throws Exception {
    }

    @Override
    public Collection<JobID> getJobIds() throws Exception {
        return Collections.singleton(this.jobGraph.getJobID());
    }
}

