/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.healthmanager.metrics;

import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.healthmanager.metrics.MetricSubscription;
import org.apache.flink.runtime.healthmanager.metrics.timeline.TimelineAggregator;
import org.apache.flink.runtime.healthmanager.metrics.timeline.TimelineAggregatorDescriptor;

public class TaskManagerMetricSubscription
extends MetricSubscription<Tuple2<Long, Double>> {
    private String tmId;
    private TimelineAggregator timelineAggregator;

    public TaskManagerMetricSubscription(String tmId, String metricName, TimelineAggregatorDescriptor timelineAggregatorDescriptor) {
        super(metricName, timelineAggregatorDescriptor);
        this.tmId = tmId;
        this.timelineAggregator = this.getTimelineAggregatorDescriptor().createTimelineAggregator();
    }

    @Override
    public Tuple2<Long, Double> getValue() {
        return this.timelineAggregator.getValue();
    }

    @Override
    public Tuple2<Long, Double> getPartialValue() {
        return this.timelineAggregator.getPartialValue();
    }

    public String getTmId() {
        return this.tmId;
    }

    public void addValue(Tuple2<Long, Double> value) {
        this.timelineAggregator.addValue(value);
    }

    public TimelineAggregator getTimelineAggregator() {
        return this.timelineAggregator;
    }
}

