/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.healthmanager.metrics.timeline;

import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.healthmanager.metrics.timeline.TimelineAggType;
import org.apache.flink.runtime.healthmanager.metrics.timeline.TimelineAggregator;
import org.apache.flink.util.Preconditions;

public class CombinedTimelineAggregator
extends TimelineAggregator {
    private TimelineAggregator totalAggregator;
    private TimelineAggregator partialTimelineAggregator;
    private long lastTimestamp = -1L;

    public CombinedTimelineAggregator(long startTimestamp, TimelineAggType timelineAggType, long interval, TimelineAggType partialTimelineAggType, long partialTimelieInterval) {
        super(startTimestamp, interval);
        Preconditions.checkArgument((interval > partialTimelieInterval && interval % partialTimelieInterval == 0L ? 1 : 0) != 0, (Object)"timeline interval mod sub timeline interval should be 0.");
        this.totalAggregator = TimelineAggregator.createTimelineAggregator(timelineAggType, interval, startTimestamp);
        this.partialTimelineAggregator = TimelineAggregator.createTimelineAggregator(partialTimelineAggType, partialTimelieInterval, startTimestamp);
    }

    @Override
    public void updateTimestamp(long timestamp) {
        this.partialTimelineAggregator.updateTimestamp(timestamp);
        Tuple2<Long, Double> subValue = this.partialTimelineAggregator.getValue();
        if (subValue != null && (Long)subValue.f0 > this.lastTimestamp) {
            this.totalAggregator.addValue(subValue);
            this.lastTimestamp = (Long)subValue.f0;
        }
        this.totalAggregator.updateTimestamp(timestamp);
    }

    @Override
    public void addValue(Tuple2<Long, Double> value) {
        this.partialTimelineAggregator.addValue(value);
        Tuple2<Long, Double> subValue = this.partialTimelineAggregator.getValue();
        if (subValue != null && (Long)subValue.f0 > this.lastTimestamp) {
            this.totalAggregator.addValue(subValue);
            this.lastTimestamp = (Long)subValue.f0;
        }
        this.totalAggregator.updateTimestamp((Long)value.f0);
    }

    @Override
    public Tuple2<Long, Double> getValue() {
        return this.totalAggregator.getValue();
    }
}

