/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.healthmanager.metrics.timeline;

import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.healthmanager.metrics.timeline.TimelineAggregator;

public class DeltaMaxTimelineAggregator
extends TimelineAggregator {
    private long nextIntervalKey = -1L;
    private double max = Double.NEGATIVE_INFINITY;
    private long lastTimestamp = -1L;
    private double lastValue = 0.0;
    private long sampleInterval;

    public DeltaMaxTimelineAggregator(long interval) {
        super(0L, interval);
        this.sampleInterval = interval / 10L;
    }

    public DeltaMaxTimelineAggregator(long startTime, long interval) {
        super(startTime, interval);
        this.sampleInterval = interval / 10L;
    }

    @Override
    public void updateTimestamp(long timestamp) {
        long intervalKey = this.getIntervalKey(timestamp);
        if (this.nextIntervalKey < intervalKey) {
            if (this.max != Double.NEGATIVE_INFINITY) {
                this.currentTimestamp = this.nextIntervalKey;
                this.currentValue = this.max;
            }
            this.nextIntervalKey = intervalKey;
            this.max = Double.NEGATIVE_INFINITY;
        }
    }

    @Override
    public void addValue(Tuple2<Long, Double> value) {
        if (this.lastTimestamp >= (Long)value.f0) {
            return;
        }
        long intervalKey = this.getIntervalKey((Long)value.f0);
        if (this.lastTimestamp + this.sampleInterval <= (Long)value.f0) {
            double delta = (Double)value.f1 - this.lastValue;
            this.lastValue = (Double)value.f1;
            this.lastTimestamp = (Long)value.f0;
            if (this.nextIntervalKey == intervalKey && this.max < delta) {
                this.max = delta;
            } else if (this.nextIntervalKey < intervalKey) {
                if (this.max != Double.NEGATIVE_INFINITY) {
                    this.currentTimestamp = this.nextIntervalKey;
                    this.currentValue = this.max;
                }
                this.nextIntervalKey = intervalKey;
                this.max = delta;
            }
        } else if (this.nextIntervalKey < intervalKey) {
            if (this.max != Double.NEGATIVE_INFINITY) {
                this.currentTimestamp = this.nextIntervalKey;
                this.currentValue = this.max;
            }
            this.nextIntervalKey = intervalKey;
            this.max = Double.NEGATIVE_INFINITY;
        }
    }
}

