/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.healthmanager.metrics.timeline;

import org.apache.commons.lang3.NotImplementedException;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.healthmanager.metrics.timeline.AvgTimelineAggregator;
import org.apache.flink.runtime.healthmanager.metrics.timeline.DeltaAvgTimelineAggregator;
import org.apache.flink.runtime.healthmanager.metrics.timeline.DeltaMaxTimelineAggregator;
import org.apache.flink.runtime.healthmanager.metrics.timeline.DeltaMinTimelineAggregator;
import org.apache.flink.runtime.healthmanager.metrics.timeline.EarliestTimelineAggregator;
import org.apache.flink.runtime.healthmanager.metrics.timeline.LatestTimelineAggregator;
import org.apache.flink.runtime.healthmanager.metrics.timeline.LatestValueAggregator;
import org.apache.flink.runtime.healthmanager.metrics.timeline.MaxTimelineAggregator;
import org.apache.flink.runtime.healthmanager.metrics.timeline.MinTimelineAggregator;
import org.apache.flink.runtime.healthmanager.metrics.timeline.RangeTimelineAggregator;
import org.apache.flink.runtime.healthmanager.metrics.timeline.RateTimelineAggregator;
import org.apache.flink.runtime.healthmanager.metrics.timeline.TimelineAggType;

public abstract class TimelineAggregator {
    protected long currentTimestamp = -1L;
    protected double currentValue = Double.NEGATIVE_INFINITY;
    private long startTimestamp;
    private long interval;
    public static final int DELTA_SAMPLE_COUNT = 10;

    public TimelineAggregator(long startTimestamp, long interval) {
        this.startTimestamp = startTimestamp;
        this.interval = interval;
    }

    public long getIntervalKey(long ts) {
        return this.startTimestamp + (ts - this.startTimestamp) / this.interval * this.interval;
    }

    public abstract void updateTimestamp(long var1);

    public abstract void addValue(Tuple2<Long, Double> var1);

    public Tuple2<Long, Double> getValue() {
        if (this.currentTimestamp == -1L) {
            return null;
        }
        return Tuple2.of((Object)this.currentTimestamp, (Object)this.currentValue);
    }

    public Tuple2<Long, Double> getPartialValue() {
        return null;
    }

    public static TimelineAggregator createTimelineAggregator(TimelineAggType timelineAggType, long interval) {
        return TimelineAggregator.createTimelineAggregator(timelineAggType, interval, 0L);
    }

    public static TimelineAggregator createTimelineAggregator(TimelineAggType timelineAggType, long interval, long startTime) {
        if (interval == 1L) {
            return new LatestValueAggregator(interval);
        }
        switch (timelineAggType) {
            case AVG: {
                return new AvgTimelineAggregator(startTime, interval);
            }
            case MAX: {
                return new MaxTimelineAggregator(startTime, interval);
            }
            case MIN: {
                return new MinTimelineAggregator(startTime, interval);
            }
            case RATE: {
                return new RateTimelineAggregator(startTime, interval);
            }
            case RANGE: {
                return new RangeTimelineAggregator(startTime, interval);
            }
            case LATEST: {
                return new LatestTimelineAggregator(startTime, interval);
            }
            case EARLIEST: {
                return new EarliestTimelineAggregator(startTime, interval);
            }
            case DELTA_AVG: {
                return new DeltaAvgTimelineAggregator(startTime, interval);
            }
            case DELTA_MIN: {
                return new DeltaMinTimelineAggregator(startTime, interval);
            }
            case DELTA_MAX: {
                return new DeltaMaxTimelineAggregator(startTime, interval);
            }
        }
        throw new NotImplementedException("Agg type:" + (Object)((Object)timelineAggType));
    }
}

