/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.healthmanager.metrics.timeline;

import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.healthmanager.metrics.timeline.CombinedTimelineAggregator;
import org.apache.flink.runtime.healthmanager.metrics.timeline.TimelineAggType;
import org.apache.flink.runtime.healthmanager.metrics.timeline.TimelineAggregator;

public interface TimelineAggregatorDescriptor {
    public TimelineAggregator createTimelineAggregator();

    public static class CombinedTimelineAggregatorDescriptor
    implements TimelineAggregatorDescriptor {
        private TimelineAggType aggType;
        private long interval;
        private TimelineAggType partialAggType;
        private long partialInterval;
        private long startTime;

        @VisibleForTesting
        public CombinedTimelineAggregatorDescriptor(TimelineAggType aggType, long interval, TimelineAggType partialAggType, long partialInterval) {
            this.aggType = aggType;
            this.interval = interval;
            this.partialAggType = partialAggType;
            this.partialInterval = partialInterval;
            this.startTime = 0L;
        }

        public CombinedTimelineAggregatorDescriptor(TimelineAggType aggType, long interval, TimelineAggType partialAggType, long partialInterval, long startTime) {
            this.aggType = aggType;
            this.interval = interval;
            this.partialAggType = partialAggType;
            this.partialInterval = partialInterval;
            this.startTime = startTime;
        }

        @Override
        public TimelineAggregator createTimelineAggregator() {
            return new CombinedTimelineAggregator(this.startTime, this.aggType, this.interval, this.partialAggType, this.partialInterval);
        }
    }

    public static class SimpleTimelineAggregatorDescriptor
    implements TimelineAggregatorDescriptor {
        private TimelineAggType aggType;
        private long interval;
        private long startTime;

        @VisibleForTesting
        public SimpleTimelineAggregatorDescriptor(TimelineAggType aggType, long interval) {
            this.aggType = aggType;
            this.interval = interval;
            this.startTime = 0L;
        }

        public SimpleTimelineAggregatorDescriptor(TimelineAggType aggType, long interval, long startTime) {
            this.aggType = aggType;
            this.interval = interval;
            this.startTime = startTime;
        }

        @Override
        public TimelineAggregator createTimelineAggregator() {
            return TimelineAggregator.createTimelineAggregator(this.aggType, this.interval, this.startTime);
        }
    }
}

