/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.healthmanager.plugins.actionselectors;

import java.util.List;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.runtime.healthmanager.HealthMonitor;
import org.apache.flink.runtime.healthmanager.plugins.Action;
import org.apache.flink.runtime.healthmanager.plugins.ActionSelector;
import org.apache.flink.runtime.healthmanager.plugins.actions.AdjustJobConfig;
import org.apache.flink.runtime.healthmanager.plugins.actions.AdjustJobResource;
import org.apache.flink.runtime.healthmanager.plugins.actions.RescaleJobParallelism;

public class RescaleResourcePriorActionSelector
implements ActionSelector {
    private static final ConfigOption<Long> ACTION_BLACK_LIST_INTERVAL = ConfigOptions.key((String)"action.selector.blacklist.interval.ms").defaultValue((Object)300000L);
    private static final ConfigOption<Boolean> ACTION_RESCALE_RESOURCE_FIRST = ConfigOptions.key((String)"action.selector.rescale.resource.first").defaultValue((Object)false);
    private Action lastFailedAction;
    private long lastFailedTime;
    private long blacklistThreshold;
    private JobID jobId;
    private boolean rescaleResourceFirst;

    @Override
    public void open(HealthMonitor monitor) {
        this.blacklistThreshold = monitor.getConfig().getLong(ACTION_BLACK_LIST_INTERVAL);
        this.rescaleResourceFirst = monitor.getConfig().getBoolean(ACTION_RESCALE_RESOURCE_FIRST);
        this.jobId = monitor.getJobID();
    }

    @Override
    public void close() {
    }

    @Override
    public Action accept(List<Action> actions) {
        AdjustJobConfig adjustJobResource = null;
        AdjustJobConfig rescaleJobParallelism = null;
        for (Action action : actions) {
            if (action instanceof AdjustJobResource) {
                if (adjustJobResource == null) {
                    adjustJobResource = (AdjustJobResource)action;
                    continue;
                }
                adjustJobResource = ((AdjustJobResource)action).merge((AdjustJobResource)adjustJobResource);
                continue;
            }
            if (!(action instanceof RescaleJobParallelism)) continue;
            rescaleJobParallelism = (RescaleJobParallelism)action;
        }
        if (this.rescaleResourceFirst && adjustJobResource != null && adjustJobResource.getActionMode() == Action.ActionMode.IMMEDIATE) {
            return adjustJobResource;
        }
        if (rescaleJobParallelism != null && rescaleJobParallelism.getActionMode() == Action.ActionMode.IMMEDIATE) {
            return rescaleJobParallelism;
        }
        if (adjustJobResource != null && adjustJobResource.getActionMode() == Action.ActionMode.IMMEDIATE) {
            return adjustJobResource;
        }
        return null;
    }

    @Override
    public void actionFailed(Action action) {
        this.lastFailedAction = action;
        this.lastFailedTime = System.currentTimeMillis();
    }

    @Override
    public void actionSucceed(Action action) {
    }
}

