/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.healthmanager.plugins.detectors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.healthmanager.HealthMonitor;
import org.apache.flink.runtime.healthmanager.metrics.MetricAggType;
import org.apache.flink.runtime.healthmanager.metrics.MetricProvider;
import org.apache.flink.runtime.healthmanager.metrics.TaskMetricSubscription;
import org.apache.flink.runtime.healthmanager.metrics.timeline.TimelineAggType;
import org.apache.flink.runtime.healthmanager.plugins.Detector;
import org.apache.flink.runtime.healthmanager.plugins.Symptom;
import org.apache.flink.runtime.healthmanager.plugins.symptoms.JobVertexDelayIncreasing;
import org.apache.flink.runtime.healthmanager.plugins.utils.HealthMonitorOptions;
import org.apache.flink.runtime.healthmanager.plugins.utils.MetricUtils;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelayIncreasingDetector
implements Detector {
    private static final Logger LOGGER = LoggerFactory.getLogger(DelayIncreasingDetector.class);
    private JobID jobID;
    private HealthMonitor healthMonitor;
    private MetricProvider metricProvider;
    private long delayIncreasingCheckInterval;
    private Map<JobVertexID, TaskMetricSubscription> delayRateSubs;

    @Override
    public void open(HealthMonitor monitor) {
        this.healthMonitor = monitor;
        this.jobID = monitor.getJobID();
        this.metricProvider = monitor.getMetricProvider();
        this.delayIncreasingCheckInterval = monitor.getConfig().getLong(HealthMonitorOptions.PARALLELISM_SCALE_INTERVAL);
        this.delayRateSubs = new HashMap<JobVertexID, TaskMetricSubscription>();
        for (JobVertexID vertexId : monitor.getJobConfig().getVertexConfigs().keySet()) {
            if (monitor.getJobConfig().getInputNodes().get((Object)vertexId).size() != 0) continue;
            TaskMetricSubscription delaySub = this.metricProvider.subscribeTaskMetric(this.jobID, vertexId, "fetched_delay", MetricAggType.MAX, this.delayIncreasingCheckInterval, TimelineAggType.DELTA_MIN);
            this.delayRateSubs.put(vertexId, delaySub);
        }
    }

    @Override
    public void close() {
        if (this.metricProvider != null && this.delayRateSubs != null) {
            for (TaskMetricSubscription delaySub : this.delayRateSubs.values()) {
                if (delaySub == null) continue;
                this.metricProvider.unsubscribe(delaySub);
            }
        }
    }

    @Override
    public Symptom detect() throws Exception {
        LOGGER.debug("Start detecting.");
        ArrayList<JobVertexID> jobVertexIDs = new ArrayList<JobVertexID>();
        for (JobVertexID vertexId : this.delayRateSubs.keySet()) {
            TaskMetricSubscription delayRateSub = this.delayRateSubs.get((Object)vertexId);
            if (!MetricUtils.validateTaskMetric(this.healthMonitor, this.delayIncreasingCheckInterval * 2L, delayRateSub)) {
                LOGGER.debug("Skip vertex {}, metrics missing.", (Object)vertexId);
                continue;
            }
            if (!((Double)delayRateSub.getValue().f1 > 0.0)) continue;
            jobVertexIDs.add(vertexId);
        }
        if (!jobVertexIDs.isEmpty()) {
            LOGGER.info("Delay increasing detected for vertices {}.", jobVertexIDs);
            return new JobVertexDelayIncreasing(this.jobID, jobVertexIDs);
        }
        return null;
    }
}

