/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.healthmanager.plugins.detectors;

import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.runtime.healthmanager.HealthMonitor;
import org.apache.flink.runtime.healthmanager.RestServerClient;
import org.apache.flink.runtime.healthmanager.metrics.JobTMMetricSubscription;
import org.apache.flink.runtime.healthmanager.metrics.MetricProvider;
import org.apache.flink.runtime.healthmanager.metrics.timeline.TimelineAggType;
import org.apache.flink.runtime.healthmanager.plugins.Detector;
import org.apache.flink.runtime.healthmanager.plugins.Symptom;
import org.apache.flink.runtime.healthmanager.plugins.symptoms.JobVertexHighCpu;
import org.apache.flink.runtime.healthmanager.plugins.utils.HealthMonitorOptions;
import org.apache.flink.runtime.healthmanager.plugins.utils.MetricUtils;
import org.apache.flink.runtime.jobgraph.ExecutionVertexID;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HighCpuDetector
implements Detector {
    private static final Logger LOGGER = LoggerFactory.getLogger(HighCpuDetector.class);
    public static final ConfigOption<Double> HIGH_CPU_THRESHOLD = ConfigOptions.key((String)"healthmonitor.high-cpu-detector.threashold").defaultValue((Object)1.0);
    public static final ConfigOption<Double> HIGH_CPU_SEVERE_THRESHOLD = ConfigOptions.key((String)"healthmonitor.high-cpu-detector.severe.threashold").defaultValue((Object)1.2);
    private JobID jobID;
    private RestServerClient restServerClient;
    private MetricProvider metricProvider;
    private HealthMonitor monitor;
    private long checkInterval;
    private double threshold;
    private double severeThreshold;
    private JobTMMetricSubscription tmCpuAllocatedSubscription;
    private JobTMMetricSubscription tmCpuUsageSubscription;

    @Override
    public void open(HealthMonitor monitor) {
        this.monitor = monitor;
        this.jobID = monitor.getJobID();
        this.restServerClient = monitor.getRestServerClient();
        this.metricProvider = monitor.getMetricProvider();
        this.checkInterval = monitor.getConfig().getLong(HealthMonitorOptions.RESOURCE_SCALE_INTERVAL);
        this.threshold = monitor.getConfig().getDouble(HIGH_CPU_THRESHOLD);
        this.severeThreshold = monitor.getConfig().getDouble(HIGH_CPU_SEVERE_THRESHOLD);
        this.tmCpuAllocatedSubscription = this.metricProvider.subscribeAllTMMetric(this.jobID, "Status.ProcessTree.CPU.Allocated", this.checkInterval, TimelineAggType.AVG);
        this.tmCpuUsageSubscription = this.metricProvider.subscribeAllTMMetric(this.jobID, "Status.ProcessTree.CPU.Usage", this.checkInterval, TimelineAggType.AVG);
    }

    @Override
    public void close() {
        if (this.metricProvider != null && this.tmCpuAllocatedSubscription != null) {
            this.metricProvider.unsubscribe(this.tmCpuAllocatedSubscription);
        }
        if (this.metricProvider != null && this.tmCpuUsageSubscription != null) {
            this.metricProvider.unsubscribe(this.tmCpuUsageSubscription);
        }
    }

    @Override
    public Symptom detect() throws Exception {
        LOGGER.debug("Start detecting.");
        Object tmCapacities = this.tmCpuAllocatedSubscription.getValue();
        Object tmUsages = this.tmCpuUsageSubscription.getValue();
        if (tmCapacities == null || tmCapacities.isEmpty() || tmUsages == null || tmUsages.isEmpty()) {
            return null;
        }
        boolean severe = false;
        HashMap<JobVertexID, Double> vertexMaxUtility = new HashMap<JobVertexID, Double>();
        for (String tmId : tmCapacities.keySet()) {
            if (!MetricUtils.validateTmMetric(this.monitor, this.checkInterval * 2L, (Tuple2)tmCapacities.get(tmId), (Tuple2)tmUsages.get(tmId))) {
                LOGGER.debug("Skip tm {}, metrics missing.", (Object)tmId);
                continue;
            }
            double capacity = (Double)((Tuple2)tmCapacities.get((Object)tmId)).f1;
            double usage = (Double)((Tuple2)tmUsages.get((Object)tmId)).f1;
            LOGGER.debug("TM {}, capacity {}, usage {}.", new Object[]{tmId, capacity, usage});
            if (capacity == 0.0) {
                LOGGER.warn("Skip vertex {}, capacity is 0. SHOULD NOT HAPPEN!", (Object)tmId);
                continue;
            }
            double utility = usage / capacity;
            if (!(utility > this.threshold)) continue;
            if (utility > this.severeThreshold) {
                severe = true;
            }
            List<ExecutionVertexID> jobExecutionVertexIds = this.restServerClient.getTaskManagerTasks(tmId);
            for (ExecutionVertexID jobExecutionVertexId : jobExecutionVertexIds) {
                JobVertexID jvId = jobExecutionVertexId.getJobVertexID();
                if (vertexMaxUtility.containsKey((Object)jvId) && !((Double)vertexMaxUtility.get((Object)jvId) < utility)) continue;
                vertexMaxUtility.put(jvId, utility);
            }
            LOGGER.debug("Cpu high detected for tm {}, capacity {}, usage {}, utility {}, tasks of vertices {}.", new Object[]{tmId, capacity, usage, utility, jobExecutionVertexIds.stream().map(evid -> evid.getJobVertexID()).collect(Collectors.toList())});
        }
        if (vertexMaxUtility != null && !vertexMaxUtility.isEmpty()) {
            LOGGER.info("Cpu high detected for vertices with max utilities {}.", vertexMaxUtility);
            return new JobVertexHighCpu(this.jobID, vertexMaxUtility, severe);
        }
        return null;
    }
}

