/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.healthmanager.plugins.detectors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.runtime.healthmanager.HealthMonitor;
import org.apache.flink.runtime.healthmanager.RestServerClient;
import org.apache.flink.runtime.healthmanager.metrics.MetricAggType;
import org.apache.flink.runtime.healthmanager.metrics.MetricProvider;
import org.apache.flink.runtime.healthmanager.metrics.TaskMetricSubscription;
import org.apache.flink.runtime.healthmanager.metrics.timeline.TimelineAggType;
import org.apache.flink.runtime.healthmanager.plugins.Detector;
import org.apache.flink.runtime.healthmanager.plugins.Symptom;
import org.apache.flink.runtime.healthmanager.plugins.symptoms.JobStuck;
import org.apache.flink.runtime.healthmanager.plugins.utils.MetricUtils;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobStuckDetector
implements Detector {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobStuckDetector.class);
    public static final ConfigOption<Long> JOB_STUCK_CHECK_INTERVAL = ConfigOptions.key((String)"healthmonitor.job-stuck.interval.ms").defaultValue((Object)60000L);
    private JobID jobID;
    private HealthMonitor healthMonitor;
    private MetricProvider metricProvider;
    private long checkInterval;
    private Map<JobVertexID, TaskMetricSubscription> inputTpsSubs;

    @Override
    public void open(HealthMonitor monitor) {
        this.healthMonitor = monitor;
        this.jobID = monitor.getJobID();
        this.metricProvider = monitor.getMetricProvider();
        this.checkInterval = monitor.getConfig().getLong(JOB_STUCK_CHECK_INTERVAL);
        this.inputTpsSubs = new HashMap<JobVertexID, TaskMetricSubscription>();
        RestServerClient.JobConfig jobConfig = monitor.getJobConfig();
        for (JobVertexID vertexId : jobConfig.getVertexConfigs().keySet()) {
            this.inputTpsSubs.put(vertexId, this.metricProvider.subscribeTaskMetric(this.jobID, vertexId, "numRecordsReceived", MetricAggType.SUM, this.checkInterval, TimelineAggType.RATE));
        }
    }

    @Override
    public void close() {
        if (this.metricProvider != null && this.inputTpsSubs != null) {
            for (TaskMetricSubscription inputTpsSub : this.inputTpsSubs.values()) {
                if (inputTpsSub == null) continue;
                this.metricProvider.unsubscribe(inputTpsSub);
            }
        }
    }

    @Override
    public Symptom detect() throws Exception {
        LOGGER.debug("Start detecting.");
        ArrayList<JobVertexID> jobVertexIDs = new ArrayList<JobVertexID>();
        for (JobVertexID vertexId : this.inputTpsSubs.keySet()) {
            TaskMetricSubscription inputSub = this.inputTpsSubs.get((Object)vertexId);
            if (!MetricUtils.validateTaskMetric(this.healthMonitor, this.checkInterval * 2L, inputSub)) {
                LOGGER.debug("Skip vertex {}, metrics missing.", (Object)vertexId);
                continue;
            }
            if (!((Double)inputSub.getValue().f1 <= 0.0)) continue;
            jobVertexIDs.add(vertexId);
        }
        if (!jobVertexIDs.isEmpty()) {
            LOGGER.info("Job stuck detected for vertices {}.", jobVertexIDs);
            return new JobStuck(this.jobID, jobVertexIDs);
        }
        return null;
    }
}

