/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.healthmanager.plugins.detectors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.runtime.healthmanager.HealthMonitor;
import org.apache.flink.runtime.healthmanager.metrics.MetricAggType;
import org.apache.flink.runtime.healthmanager.metrics.MetricProvider;
import org.apache.flink.runtime.healthmanager.metrics.TaskMetricSubscription;
import org.apache.flink.runtime.healthmanager.metrics.timeline.TimelineAggType;
import org.apache.flink.runtime.healthmanager.plugins.Detector;
import org.apache.flink.runtime.healthmanager.plugins.Symptom;
import org.apache.flink.runtime.healthmanager.plugins.symptoms.JobVertexLowDelay;
import org.apache.flink.runtime.healthmanager.plugins.utils.HealthMonitorOptions;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LowDelayDetector
implements Detector {
    private static final Logger LOGGER = LoggerFactory.getLogger(LowDelayDetector.class);
    public static final ConfigOption<Long> LOW_DELAY_THRESHOLD = ConfigOptions.key((String)"healthmonitor.low-delay.threshold").defaultValue((Object)300000L);
    private JobID jobID;
    private MetricProvider metricProvider;
    private long lowDelayCheckInterval;
    private long lowDelayThreshold;
    private Map<JobVertexID, TaskMetricSubscription> delaySubs;

    @Override
    public void open(HealthMonitor monitor) {
        this.jobID = monitor.getJobID();
        this.metricProvider = monitor.getMetricProvider();
        this.lowDelayCheckInterval = monitor.getConfig().getLong(HealthMonitorOptions.PARALLELISM_SCALE_INTERVAL);
        this.lowDelayThreshold = monitor.getConfig().getLong(LOW_DELAY_THRESHOLD);
        this.delaySubs = new HashMap<JobVertexID, TaskMetricSubscription>();
        for (JobVertexID vertexId : monitor.getJobConfig().getVertexConfigs().keySet()) {
            if (monitor.getJobConfig().getInputNodes().get((Object)vertexId).size() != 0) continue;
            TaskMetricSubscription delaySub = this.metricProvider.subscribeTaskMetric(this.jobID, vertexId, "fetched_delay", MetricAggType.MAX, this.lowDelayCheckInterval, TimelineAggType.AVG);
            this.delaySubs.put(vertexId, delaySub);
        }
    }

    @Override
    public void close() {
        if (this.metricProvider != null && this.delaySubs != null) {
            for (TaskMetricSubscription delaySub : this.delaySubs.values()) {
                if (delaySub == null) continue;
                this.metricProvider.unsubscribe(delaySub);
            }
        }
    }

    @Override
    public Symptom detect() throws Exception {
        LOGGER.debug("Start detecting.");
        long now = System.currentTimeMillis();
        ArrayList<JobVertexID> jobVertexIDs = new ArrayList<JobVertexID>();
        for (JobVertexID vertexId : this.delaySubs.keySet()) {
            TaskMetricSubscription delaySub = this.delaySubs.get((Object)vertexId);
            if (delaySub.getValue() == null || now - (Long)delaySub.getValue().f0 > this.lowDelayCheckInterval * 2L) {
                LOGGER.debug("Skip vertex {}, metrics missing.", (Object)vertexId);
                continue;
            }
            if (!((Double)delaySub.getValue().f1 < (double)this.lowDelayThreshold)) continue;
            jobVertexIDs.add(vertexId);
        }
        if (!jobVertexIDs.isEmpty()) {
            LOGGER.info("Low delay detected for vertices {}.", jobVertexIDs);
            return new JobVertexLowDelay(this.jobID, jobVertexIDs);
        }
        return null;
    }
}

