/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.healthmanager.plugins.symptoms;

import java.util.Map;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.healthmanager.plugins.Symptom;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.util.Preconditions;

public class JobVertexHighNativeMemory
implements Symptom {
    private JobID jobID;
    Map<JobVertexID, Double> utilities;
    private boolean severe;
    private boolean critical;

    public JobVertexHighNativeMemory(JobID jobID, Map<JobVertexID, Double> utilities, boolean severe, boolean critical) {
        this.jobID = jobID;
        this.utilities = utilities;
        this.severe = severe;
        this.critical = critical;
        if (critical) {
            Preconditions.checkArgument((boolean)severe);
        }
    }

    public JobID getJobID() {
        return this.jobID;
    }

    public Map<JobVertexID, Double> getUtilities() {
        return this.utilities;
    }

    public boolean isSevere() {
        return this.severe;
    }

    public boolean isCritical() {
        return this.critical;
    }

    public String toString() {
        return String.format("%s[severe:%s][critical:%s][utilities:%s]", this.getClass().getSimpleName(), this.severe, this.critical, this.utilities);
    }
}

