/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.healthmanager.plugins.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.healthmanager.RestServerClient;
import org.apache.flink.runtime.jobgraph.JobVertexID;

public class JobTopologyAnalyzer {
    private Map<JobVertexID, List<JobVertexID>> subDagRoot2SubDagVertex = new HashMap<JobVertexID, List<JobVertexID>>();
    private Map<JobVertexID, JobVertexID> vertex2SubDagRoot = new HashMap<JobVertexID, JobVertexID>();
    private Map<JobVertexID, List<JobVertexID>> inputs = new HashMap<JobVertexID, List<JobVertexID>>();
    private Map<JobVertexID, List<JobVertexID>> outputs = new HashMap<JobVertexID, List<JobVertexID>>();

    public void analyze(RestServerClient.JobConfig jobConfig) {
        this.subDagRoot2SubDagVertex = new HashMap<JobVertexID, List<JobVertexID>>();
        this.vertex2SubDagRoot = new HashMap<JobVertexID, JobVertexID>();
        this.inputs = new HashMap<JobVertexID, List<JobVertexID>>();
        this.outputs = new HashMap<JobVertexID, List<JobVertexID>>();
        for (JobVertexID vertexId : jobConfig.getVertexConfigs().keySet()) {
            this.subDagRoot2SubDagVertex.put(vertexId, new ArrayList());
            this.subDagRoot2SubDagVertex.get((Object)vertexId).add(vertexId);
            this.vertex2SubDagRoot.put(vertexId, vertexId);
            this.inputs.put(vertexId, new ArrayList());
            this.outputs.put(vertexId, new ArrayList());
        }
        for (JobVertexID vertexId : jobConfig.getInputNodes().keySet()) {
            List<Tuple2<JobVertexID, String>> upstreamVertices = jobConfig.getInputNodes().get((Object)vertexId);
            for (Tuple2<JobVertexID, String> entry : upstreamVertices) {
                this.inputs.get((Object)vertexId).add((JobVertexID)((Object)entry.f0));
                this.outputs.get(entry.f0).add(vertexId);
            }
            if (upstreamVertices.size() != 1) continue;
            JobVertexID upstreamVertex = (JobVertexID)((Object)upstreamVertices.get((int)0).f0);
            JobVertexID upstreamSubDagRoot = this.vertex2SubDagRoot.get((Object)upstreamVertex);
            for (JobVertexID subDagVertex : this.subDagRoot2SubDagVertex.get((Object)vertexId)) {
                this.subDagRoot2SubDagVertex.get((Object)upstreamSubDagRoot).add(subDagVertex);
                this.vertex2SubDagRoot.put(subDagVertex, upstreamSubDagRoot);
            }
            this.subDagRoot2SubDagVertex.remove((Object)vertexId);
        }
    }

    public boolean isSource(JobVertexID vertexID) {
        return this.inputs.get((Object)vertexID).isEmpty();
    }

    public boolean isSink(JobVertexID vertexID) {
        return this.outputs.get((Object)vertexID).isEmpty();
    }

    public List<JobVertexID> getInputs(JobVertexID vertexID) {
        return this.inputs.get((Object)vertexID);
    }

    public List<JobVertexID> getOutputs(JobVertexID vertexID) {
        return this.outputs.get((Object)vertexID);
    }

    public JobVertexID getSubDagRoot(JobVertexID vertexID) {
        return this.vertex2SubDagRoot.get((Object)vertexID);
    }

    public List<JobVertexID> getSubDagVertices(JobVertexID vertexID) {
        return this.subDagRoot2SubDagVertex.get((Object)this.vertex2SubDagRoot.get((Object)vertexID));
    }

    public Set<JobVertexID> getAllSubDagRoots() {
        return this.subDagRoot2SubDagVertex.keySet();
    }
}

