/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.disk;

import java.io.EOFException;
import java.io.IOException;
import java.util.List;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentSource;
import org.apache.flink.runtime.memory.AbstractPagedOutputView;
import org.apache.flink.util.MathUtils;

public class SimpleCollectingOutputView
extends AbstractPagedOutputView {
    private final List<MemorySegment> fullSegments;
    private final MemorySegmentSource memorySource;
    private final int segmentSizeBits;
    private int segmentNum;

    public SimpleCollectingOutputView(List<MemorySegment> fullSegmentTarget, MemorySegmentSource memSource, int segmentSize) {
        super(memSource.nextSegment(), segmentSize, 0);
        this.segmentSizeBits = MathUtils.log2strict((int)segmentSize);
        this.fullSegments = fullSegmentTarget;
        this.memorySource = memSource;
        this.fullSegments.add(this.getCurrentSegment());
    }

    public void reset() {
        if (this.fullSegments.size() != 0) {
            throw new IllegalStateException("The target list still contains memory segments.");
        }
        this.clear();
        try {
            this.advance();
        }
        catch (IOException ioex) {
            throw new RuntimeException("Error getting first segment for record collector.", ioex);
        }
        this.segmentNum = 0;
    }

    protected MemorySegment nextSegment(MemorySegment current, int positionInCurrent) throws EOFException {
        MemorySegment next = this.memorySource.nextSegment();
        if (next != null) {
            this.fullSegments.add(next);
            ++this.segmentNum;
            return next;
        }
        throw new EOFException();
    }

    public long getCurrentOffset() {
        return ((long)this.segmentNum << this.segmentSizeBits) + (long)this.getCurrentPositionInSegment();
    }
}

