/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.disk.iomanager;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.flink.runtime.io.disk.iomanager.AsynchronousFileIOChannel;
import org.apache.flink.runtime.io.disk.iomanager.BufferFileSegmentReader;
import org.apache.flink.runtime.io.disk.iomanager.FileIOChannel;
import org.apache.flink.runtime.io.disk.iomanager.FileSegment;
import org.apache.flink.runtime.io.disk.iomanager.FileSegmentReadRequest;
import org.apache.flink.runtime.io.disk.iomanager.IORequestScheduler;
import org.apache.flink.runtime.io.disk.iomanager.ReadRequest;
import org.apache.flink.runtime.io.disk.iomanager.RequestDoneCallback;
import org.apache.flink.runtime.io.disk.iomanager.SeekRequest;

public class AsynchronousBufferFileSegmentReader
extends AsynchronousFileIOChannel<FileSegment, ReadRequest>
implements BufferFileSegmentReader {
    private final AtomicBoolean hasReachedEndOfFile = new AtomicBoolean();

    protected AsynchronousBufferFileSegmentReader(FileIOChannel.ID channelID, IORequestScheduler<ReadRequest> requestScheduler, RequestDoneCallback<FileSegment> callback) throws IOException {
        super(channelID, requestScheduler, callback, false);
    }

    @Override
    public void read() throws IOException {
        this.addRequest(new FileSegmentReadRequest(this, this.hasReachedEndOfFile));
    }

    @Override
    public void seekTo(long position) throws IOException {
        this.requestScheduler.addRequest(this.id, new SeekRequest(this, position, -1));
    }

    @Override
    public boolean hasReachedEndOfFile() {
        return this.hasReachedEndOfFile.get();
    }
}

