/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.disk.iomanager;

import java.io.IOException;
import org.apache.flink.runtime.io.disk.iomanager.AsynchronousFileIOChannel;
import org.apache.flink.runtime.io.disk.iomanager.BufferFileWriter;
import org.apache.flink.runtime.io.disk.iomanager.BufferWriteRequest;
import org.apache.flink.runtime.io.disk.iomanager.FileIOChannel;
import org.apache.flink.runtime.io.disk.iomanager.IORequestScheduler;
import org.apache.flink.runtime.io.disk.iomanager.RequestDoneCallback;
import org.apache.flink.runtime.io.disk.iomanager.StreamWriteRequest;
import org.apache.flink.runtime.io.disk.iomanager.WriteRequest;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.util.event.NotificationListener;
import org.apache.flink.util.ExceptionUtils;

public class AsynchronousBufferFileWriter
extends AsynchronousFileIOChannel<Buffer, WriteRequest>
implements BufferFileWriter {
    private static final RecyclingCallback CALLBACK = new RecyclingCallback();
    private final int bufferSize;
    private final boolean withHeader;

    protected AsynchronousBufferFileWriter(FileIOChannel.ID channelID, IORequestScheduler<WriteRequest> requestScheduler, int bufferSize, boolean withHeader) throws IOException {
        super(channelID, requestScheduler, CALLBACK, true);
        this.bufferSize = bufferSize;
        this.withHeader = withHeader;
    }

    protected AsynchronousBufferFileWriter(FileIOChannel.ID channelID, IORequestScheduler<WriteRequest> requestScheduler, int bufferSize) throws IOException {
        this(channelID, requestScheduler, bufferSize, true);
    }

    @Override
    public void writeBlock(Buffer buffer) throws IOException {
        try {
            if (this.withHeader) {
                this.addRequest(new BufferWriteRequest(this, buffer, this.bufferSize));
            } else {
                this.addRequest(new StreamWriteRequest(this, buffer, this.bufferSize));
            }
        }
        catch (Throwable e) {
            buffer.recycleBuffer();
            ExceptionUtils.rethrowIOException((Throwable)e);
        }
    }

    @Override
    public int getNumberOfOutstandingRequests() {
        return this.requestsNotReturned.get();
    }

    @Override
    public boolean registerAllRequestsProcessedListener(NotificationListener listener) throws IOException {
        return super.registerAllRequestsProcessedListener(listener);
    }

    private static class RecyclingCallback
    implements RequestDoneCallback<Buffer> {
        private RecyclingCallback() {
        }

        @Override
        public void requestSuccessful(Buffer buffer) {
            buffer.recycleBuffer();
        }

        @Override
        public void requestFailed(Buffer buffer, IOException e) {
            buffer.recycleBuffer();
        }
    }
}

