/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.disk.iomanager;

import java.io.EOFException;
import java.io.IOException;
import java.util.List;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.disk.iomanager.BlockChannelReader;
import org.apache.flink.runtime.io.disk.iomanager.ChannelReaderInputView;
import org.apache.flink.util.Preconditions;

public class HeaderlessChannelReaderInputView
extends ChannelReaderInputView {
    private int numBlocksRemaining;
    private final int lastBlockBytes;
    private long offset;
    private boolean isFirstBlock;

    public HeaderlessChannelReaderInputView(BlockChannelReader<MemorySegment> reader, List<MemorySegment> memory, int numBlocks, int numBytesInLastBlock, boolean waitForFirstBlock) throws IOException {
        this(reader, memory, numBlocks, numBytesInLastBlock, waitForFirstBlock, 0L);
    }

    public HeaderlessChannelReaderInputView(BlockChannelReader<MemorySegment> reader, List<MemorySegment> memory, int numBlocks, int numBytesInLastBlock, boolean waitForFirstBlock, long offset) throws IOException {
        super(reader, memory, numBlocks, 0, false);
        Preconditions.checkArgument((offset >= 0L ? 1 : 0) != 0, (Object)"`offset` can't be negative!");
        this.numBlocksRemaining = numBlocks;
        this.lastBlockBytes = numBytesInLastBlock;
        this.offset = offset;
        if (waitForFirstBlock) {
            this.advance();
        }
    }

    @Override
    protected MemorySegment nextSegment(MemorySegment current) throws IOException {
        if (this.numBlocksRemaining <= 0) {
            this.reader.close();
            throw new EOFException();
        }
        if (current != null) {
            this.sendReadRequest(current);
        }
        this.isFirstBlock = current == null;
        --this.numBlocksRemaining;
        return (MemorySegment)this.reader.getNextReturnedBlock();
    }

    protected void afterAdvance() {
        if (this.isFirstBlock && this.offset > 0L) {
            this.seekInput(this.getCurrentSegment(), (int)this.offset, this.getCurrentSegmentLimit());
        }
    }

    @Override
    protected int getLimitForSegment(MemorySegment segment) {
        return this.numBlocksRemaining > 0 ? segment.size() : this.lastBlockBytes;
    }
}

