/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.disk.iomanager;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.disk.iomanager.BlockChannelReader;
import org.apache.flink.runtime.io.disk.iomanager.BlockChannelWriter;
import org.apache.flink.runtime.io.disk.iomanager.BlockChannelWriterWithCallback;
import org.apache.flink.runtime.io.disk.iomanager.BufferFileReader;
import org.apache.flink.runtime.io.disk.iomanager.BufferFileSegmentReader;
import org.apache.flink.runtime.io.disk.iomanager.BufferFileWriter;
import org.apache.flink.runtime.io.disk.iomanager.BulkBlockChannelReader;
import org.apache.flink.runtime.io.disk.iomanager.FileIOChannel;
import org.apache.flink.runtime.io.disk.iomanager.FileSegment;
import org.apache.flink.runtime.io.disk.iomanager.RequestDoneCallback;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.util.FileUtils;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IOManager {
    protected static final Logger LOG = LoggerFactory.getLogger(IOManager.class);
    private final File[] paths;
    private final Random random;
    private volatile int nextPath;
    private volatile int nextThread;
    private final int numThreads;

    protected IOManager(String[] tempDirs, int numThreads) {
        Preconditions.checkArgument((numThreads > 0 ? 1 : 0) != 0, (Object)("The number of read/write threads must be positive, but actual is " + numThreads));
        Preconditions.checkArgument((tempDirs != null && tempDirs.length != 0 ? 1 : 0) != 0, (Object)"The temporary directories must not be null or empty.");
        this.numThreads = numThreads;
        this.random = new Random();
        this.nextPath = 0;
        this.paths = new File[tempDirs.length];
        for (int i = 0; i < tempDirs.length; ++i) {
            File baseDir = new File(tempDirs[i]);
            String subfolder = String.format("flink-io-%s", UUID.randomUUID().toString());
            File storageDir = new File(baseDir, subfolder);
            if (!storageDir.exists() && !storageDir.mkdirs()) {
                throw new RuntimeException("Could not create storage directory for IOManager: " + storageDir.getAbsolutePath());
            }
            this.paths[i] = storageDir;
            LOG.info("I/O manager uses directory {} for spill files.", (Object)storageDir.getAbsolutePath());
        }
    }

    public void shutdown() {
        for (File path : this.paths) {
            try {
                if (path == null || !path.exists()) continue;
                FileUtils.deleteDirectory((File)path);
                LOG.info("I/O manager removed spill file directory {}", (Object)path.getAbsolutePath());
            }
            catch (Throwable t) {
                LOG.error("IOManager failed to properly clean up temp file directory: " + path, t);
            }
        }
    }

    public boolean isProperlyShutDown() {
        for (File path : this.paths) {
            if (path == null || !path.exists()) continue;
            return false;
        }
        return true;
    }

    public FileIOChannel.ID createChannel() {
        int pathNum = this.getNextPathNum();
        int threadNum = this.getNextThreadNum();
        return new FileIOChannel.ID(this.paths[pathNum], threadNum, this.random);
    }

    public FileIOChannel.ID createChannel(File path) {
        int threadNum = this.getNextThreadNum();
        for (File localPath : this.paths) {
            if (!path.getPath().startsWith(localPath.getPath())) continue;
            throw new RuntimeException(path.getPath() + " is not allowed in path: " + localPath.toString());
        }
        return new FileIOChannel.ID(path, threadNum);
    }

    public FileIOChannel.Enumerator createChannelEnumerator() {
        return new FileIOChannel.Enumerator(this.paths, this.random, this.numThreads);
    }

    public void deleteChannel(FileIOChannel.ID channel) throws IOException {
        if (channel != null && channel.getPathFile().exists() && !channel.getPathFile().delete()) {
            LOG.warn("IOManager failed to delete temporary file {}", (Object)channel.getPath());
        }
    }

    public BlockChannelWriter<MemorySegment> createBlockChannelWriter(FileIOChannel.ID channelID) throws IOException {
        return this.createBlockChannelWriter(channelID, new LinkedBlockingQueue<MemorySegment>());
    }

    public abstract BlockChannelWriter<MemorySegment> createBlockChannelWriter(FileIOChannel.ID var1, LinkedBlockingQueue<MemorySegment> var2) throws IOException;

    public abstract BlockChannelWriterWithCallback<MemorySegment> createBlockChannelWriter(FileIOChannel.ID var1, RequestDoneCallback<MemorySegment> var2) throws IOException;

    public BlockChannelReader<MemorySegment> createBlockChannelReader(FileIOChannel.ID channelID) throws IOException {
        return this.createBlockChannelReader(channelID, new LinkedBlockingQueue<MemorySegment>());
    }

    public abstract BlockChannelReader<MemorySegment> createBlockChannelReader(FileIOChannel.ID var1, LinkedBlockingQueue<MemorySegment> var2) throws IOException;

    public abstract BufferFileWriter createBufferFileWriter(FileIOChannel.ID var1) throws IOException;

    public abstract BufferFileReader createBufferFileReader(FileIOChannel.ID var1, RequestDoneCallback<Buffer> var2) throws IOException;

    public abstract BufferFileSegmentReader createBufferFileSegmentReader(FileIOChannel.ID var1, RequestDoneCallback<FileSegment> var2) throws IOException;

    public abstract BufferFileWriter createStreamFileWriter(FileIOChannel.ID var1) throws IOException;

    public abstract BufferFileReader createStreamFileReader(FileIOChannel.ID var1, RequestDoneCallback<Buffer> var2) throws IOException;

    public abstract BulkBlockChannelReader createBulkBlockChannelReader(FileIOChannel.ID var1, List<MemorySegment> var2, int var3) throws IOException;

    public int getNumberOfSpillingDirectories() {
        return this.paths.length;
    }

    public File[] getSpillingDirectories() {
        return this.paths;
    }

    public String[] getSpillingDirectoriesPaths() {
        String[] strings = new String[this.paths.length];
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = this.paths[i].getAbsolutePath();
        }
        return strings;
    }

    protected int getNextPathNum() {
        int next = this.nextPath;
        int newNext = next + 1;
        this.nextPath = newNext >= this.paths.length ? 0 : newNext;
        return next;
    }

    protected int getNextThreadNum() {
        int next = this.nextThread;
        int newNext = next + 1;
        this.nextThread = newNext >= this.numThreads ? 0 : newNext;
        return next;
    }

    public static enum IOMode {
        SYNC(true),
        ASYNC(false);

        private final boolean isSynchronous;

        private IOMode(boolean isSynchronous) {
            this.isSynchronous = isSynchronous;
        }

        public boolean isSynchronous() {
            return this.isSynchronous;
        }
    }
}

