/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.disk.iomanager;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.disk.iomanager.AsynchronousFileIOChannel;
import org.apache.flink.runtime.io.disk.iomanager.WriteRequest;
import org.apache.flink.util.FileUtils;

final class SegmentWriteRequest
implements WriteRequest {
    private final AsynchronousFileIOChannel<MemorySegment, WriteRequest> channel;
    private final MemorySegment segment;
    private final int bufferSize;

    protected SegmentWriteRequest(AsynchronousFileIOChannel<MemorySegment, WriteRequest> targetChannel, MemorySegment segment, int bufferSize) {
        this.channel = targetChannel;
        this.segment = segment;
        this.bufferSize = bufferSize;
    }

    @Override
    public void write() throws IOException {
        try {
            if (this.bufferSize == -1) {
                FileUtils.writeCompletely((WritableByteChannel)this.channel.fileChannel, (ByteBuffer)this.segment.wrap(0, this.segment.size()));
            } else {
                this.channel.getBufferedOutputStream(this.bufferSize).write(this.segment, 0, this.segment.size());
            }
        }
        catch (NullPointerException npex) {
            throw new IOException("Memory segment has been released.");
        }
    }

    @Override
    public void requestDone(IOException ioex) {
        this.channel.handleProcessedBuffer(this.segment, ioex);
    }
}

