/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.disk.iomanager;

import java.io.IOException;
import org.apache.flink.runtime.io.disk.iomanager.BufferFileChannelReader;
import org.apache.flink.runtime.io.disk.iomanager.BufferFileReader;
import org.apache.flink.runtime.io.disk.iomanager.FileIOChannel;
import org.apache.flink.runtime.io.disk.iomanager.StreamFileChannelReader;
import org.apache.flink.runtime.io.disk.iomanager.SynchronousFileIOChannel;
import org.apache.flink.runtime.io.network.buffer.Buffer;

public class SynchronousBufferFileReader
extends SynchronousFileIOChannel
implements BufferFileReader {
    private final BufferFileChannelReader reader;
    private boolean hasReachedEndOfFile;
    private final boolean withHeader;
    protected long currentPosition;

    public SynchronousBufferFileReader(FileIOChannel.ID channelID, boolean writeEnabled) throws IOException {
        this(channelID, writeEnabled, true);
    }

    public SynchronousBufferFileReader(FileIOChannel.ID channelID, boolean writeEnabled, boolean withHeader) throws IOException {
        super(channelID, writeEnabled);
        this.reader = new BufferFileChannelReader(this.fileChannel);
        this.withHeader = withHeader;
    }

    @Override
    public void readInto(Buffer buffer) throws IOException {
        if (this.withHeader) {
            if (this.fileChannel.size() - this.fileChannel.position() > 0L) {
                this.hasReachedEndOfFile = this.reader.readBufferFromFileChannel(buffer);
            } else {
                buffer.recycleBuffer();
            }
        } else {
            throw new IllegalArgumentException("Method readInto(Buffer buffer) only support withHeader mode.");
        }
    }

    @Override
    public void readInto(Buffer buffer, long length) throws IOException {
        if (!this.withHeader) {
            if (this.fileChannel.size() - this.currentPosition > 0L) {
                this.hasReachedEndOfFile = StreamFileChannelReader.readBufferFromFileChannel(this.fileChannel, buffer, this.currentPosition, length, this.id.getPathFile());
                this.currentPosition += length;
            } else {
                buffer.recycleBuffer();
                if (!this.hasReachedEndOfFile) {
                    this.hasReachedEndOfFile = true;
                }
            }
        } else {
            throw new IllegalArgumentException("Method readInto(Buffer buffer, long length) only support withoutHeader mode.");
        }
    }

    @Override
    public void seekToPosition(long position) throws IOException {
        this.currentPosition = position;
        this.fileChannel.position(position);
    }

    @Override
    public boolean hasReachedEndOfFile() {
        return this.hasReachedEndOfFile;
    }
}

