/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.api.serialization;

import java.util.Optional;
import org.apache.flink.api.common.io.blockcompression.BlockCompressionFactory;
import org.apache.flink.api.common.io.blockcompression.BlockCompressionFactoryLoader;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.runtime.io.network.api.serialization.BufferDeserializationDelegate;
import org.apache.flink.runtime.io.network.api.serialization.BufferSerializationDelegate;
import org.apache.flink.runtime.io.network.api.serialization.CompositeSpanningRecordSerializer;
import org.apache.flink.runtime.io.network.api.serialization.CompositeSpillingAdaptiveSpanningRecordDeserializer;
import org.apache.flink.runtime.io.network.api.serialization.CompressionBufferTransformer;
import org.apache.flink.runtime.io.network.api.serialization.DecompressionBufferTransformer;
import org.apache.flink.runtime.io.network.api.serialization.RecordDeserializer;
import org.apache.flink.runtime.io.network.api.serialization.RecordSerializer;
import org.apache.flink.runtime.io.network.api.serialization.SpanningRecordSerializer;
import org.apache.flink.runtime.io.network.api.serialization.SpillingAdaptiveSpanningRecordDeserializer;
import org.apache.flink.runtime.io.network.partition.BlockingShuffleType;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.io.network.partition.consumer.SingleInputGate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializerManager<T extends IOReadableWritable> {
    private static final Logger LOG = LoggerFactory.getLogger(SerializerManager.class);
    private final boolean useCompression;
    private final Optional<BlockCompressionFactory> compressionFactory;
    private final int compressionBufferSize;

    public SerializerManager(ResultPartitionType resultPartitionType, Configuration configuration) {
        if (!resultPartitionType.isBlocking()) {
            this.useCompression = false;
        } else {
            BlockingShuffleType shuffleType = BlockingShuffleType.getBlockingShuffleTypeFromConfiguration(configuration, LOG);
            boolean bl = this.useCompression = shuffleType == BlockingShuffleType.YARN && configuration.getBoolean(TaskManagerOptions.TASK_EXTERNAL_SHUFFLE_ENABLE_COMPRESSION);
        }
        if (!this.useCompression) {
            this.compressionFactory = Optional.empty();
            this.compressionBufferSize = -1;
        } else {
            this.compressionFactory = Optional.of(BlockCompressionFactoryLoader.createBlockCompressionFactory((String)configuration.getString(TaskManagerOptions.TASK_EXTERNAL_SHUFFLE_COMPRESSION_CODEC), (Configuration)configuration));
            this.compressionBufferSize = configuration.getInteger(TaskManagerOptions.TASK_EXTERNAL_SHUFFLE_COMPRESSION_BUFFER_SIZE);
        }
    }

    public SerializerManager(SingleInputGate inputGate, Configuration configuration) {
        this(inputGate.getConsumedPartitionType(), configuration);
    }

    public boolean useCompression() {
        return this.useCompression;
    }

    public RecordDeserializer<T> getRecordDeserializer(String[] tmpDirectories) {
        if (!this.useCompression) {
            return new SpillingAdaptiveSpanningRecordDeserializer(tmpDirectories);
        }
        SpillingAdaptiveSpanningRecordDeserializer<BufferDeserializationDelegate> internalDeser = new SpillingAdaptiveSpanningRecordDeserializer<BufferDeserializationDelegate>(tmpDirectories);
        DecompressionBufferTransformer internalDeserDelegate = new DecompressionBufferTransformer(this.compressionFactory.get());
        return new CompositeSpillingAdaptiveSpanningRecordDeserializer(tmpDirectories, internalDeser, internalDeserDelegate);
    }

    public RecordSerializer<IOReadableWritable> getRecordSerializer() {
        if (!this.useCompression) {
            return new SpanningRecordSerializer<IOReadableWritable>();
        }
        SpanningRecordSerializer<BufferSerializationDelegate> internalSer = new SpanningRecordSerializer<BufferSerializationDelegate>();
        CompressionBufferTransformer internalSerDelegate = new CompressionBufferTransformer(this.compressionFactory.get());
        return new CompositeSpanningRecordSerializer<IOReadableWritable>(internalSer, internalSerDelegate, this.compressionBufferSize);
    }
}

